/*
 * CobCode.java
 *
 * Created on May 6, 2001, 2:22 AM
 */

package cse605;

/**
 *
 * @author  adev
 * @version 
 */
import java.util.*;
import javax.swing.JTextArea;
import javax.swing.JScrollPane;
import javax.swing.JFrame;
import javax.swing.*;
import javax.swing.text.*;

public class CobCode extends Object {

  	private String barText;
  	private String beamText;
  	private String loadText;
  	private String jointText;
  	
    private LinkedList barList, nodeList, tempList;

    private String cobText = "";

    /** Creates new CobCode */
    public CobCode() {
 		barList = new LinkedList();        
    }
    
    public void clearAll()
    {
		barList = new LinkedList();
        nodeList = new LinkedList();
    }

    public void generateCode(LinkedList list){
    
      	barText = getBarText();
      	beamText = getBeamText();
      	jointText = getJointText();
      	loadText = getLoadText();
      	
      	
        
        if(list.size()>0) 
        barList = identifyComponents(list);
		
        /*
        String nodeAmps ="";
        String constraintText = "";
        
        String circuitText = "";
        
        
        String newWiresText="";
        String newResistorsText="";
        String newBatteriesText="";
        String newNodesText="";

		*/
		
		tempList = new LinkedList();
		String trussText = "";
		
        trussText+=
        barText+"\n\n\n\n"+beamText+"\n\n\n\n"+jointText+"\n\n\n\n"+loadText+"\n\n\n\n";


		String temp = "";
		
		temp = "class sampletruss{ \n";
		
		temp += "attributes \n";
		
		temp += "bar ";
		
		for(int i = 0; i< (barList.size()-1); i++)
			temp += ((Bar)barList.get(i)).getID() + ", "; 

		System.out.println(temp);
		
		int len = barList.size()-1;
		System.out.println(len);
		
		Bar b = (Bar)(barList.get(len));
		temp += b.getID() + ";\n"; 

		temp += "beam ";
		
		String barID;
		
		for(int i = 0; i< (barList.size()-1); i++)
			{
			barID = ((Bar)barList.get(i)).getID();
			temp += "I" + barID + ", "; 
			temp += "I" + barID.substring(1) + barID.substring(0,1) + ", ";
 
			}
			
		barID = ((Bar)barList.get(barList.size()-1)).getID();
		
		temp += "I" + barID + ", "; 
		temp += "I" + barID.substring(1) + barID.substring(0,1) + ";\n"; 

		temp += "load ";

		for(int i = 0; i< (list.size()-1); i++)
		{
			
			if(((Node)list.get(i)).getFixedJoint())
			{
				temp += "I" + "J" + Integer.toString(((Node)list.get(i)).getIDVal()) + "H" + ", ";
				temp += "I" + "J" + Integer.toString(((Node)list.get(i)).getIDVal()) + "V" + ", ";
			}
			else
			{
				if(((Node)list.get(i)).getGroundJoint())
					temp += "I" + "J" + Integer.toString(((Node)list.get(i)).getIDVal()) + "V" + ", ";
			
			}
			
			
		}	
			

		if(((Node)list.get(list.size()-1)).getFixedJoint())
		{
			temp += "I" + "J" + Integer.toString(((Node)list.get(list.size()-1)).getIDVal()) + "H" + ", ";
			temp += "I" + "J" +
			Integer.toString(((Node)list.get(list.size()-1)).getIDVal()) + "V" + ";\n";
		}
		else if(((Node)list.get(list.size()-1)).getGroundJoint())
				temp += "I" + "J" +
				Integer.toString(((Node)list.get(list.size()-1)).getIDVal()) + "V" + ";\n";
		else temp = temp.substring(0, (temp.length()-2)) + ";\n" ;
			
		
		
		temp += "beam [] ";
		
		for(int i = 0; i< (list.size()-1); i++)
		{
		
		temp += "BA" + Integer.toString(((Node)list.get(i)).getIDVal()) + ", ";
		
		}
		
		temp += "BA" + Integer.toString(((Node)list.get(list.size()-1)).getIDVal()) + ";\n";

		
		temp += "load [] ";
		
		 
		for(int i = 0; i< (list.size()-1); i++)
		{
		
		 if(((Node)list.get(i)).getFixedJoint() ||
		 ((Node)list.get(i)).getGroundJoint())	
			temp += "L" + Integer.toString(((Node)list.get(i)).getIDVal()) + ", ";
		
		}
		
		 if(((Node)list.get(list.size()-1)).getFixedJoint() ||
		 ((Node)list.get(list.size()-1)).getGroundJoint())	
			temp += "L" + Integer.toString(((Node)list.get(list.size()-1)).getIDVal()) +
			";\n";
		else
			temp = temp.substring(0, (temp.length()-2)) + ";\n" ;
		
		temp += "Real Esteel, Sy, Pi; \n";
		
		temp+= "Real ";
		
		for(int i = 0; i < (barList.size()); i++)
		{
			String x = Integer.toString(((Bar)barList.get(i)).getIDVal());
			temp += "W" + x + ", ";
			temp += "H" + x + ", ";
			temp += "F" + x + ", ";
			temp += "F" + x + "_bk" + ", ";
			temp += "F" + x + "_bn" + ", ";
			temp += "F" + x + "_t" + ", ";
			temp += "Sigma" + x + ", ";
			temp += "I" + x + ", ";
		
		}


		
		temp = temp.substring(0, (temp.length()-2)) + ";\n" ;
		
		temp += "Real ";

		for(int i = 0; i< (list.size()-1); i++)
		{
			
			if(((Node)list.get(i)).getFixedJoint())
			{
				temp += "F" + "J" +
				Integer.toString(((Node)list.get(i)).getIDVal())
				+ "H" + ", ";
				temp += "F" + "J" +
				Integer.toString(((Node)list.get(i)).getIDVal())
				+ "V" + ", ";
			}
			else
			{
				if(((Node)list.get(i)).getGroundJoint())
					temp += "F" + "J" +
					Integer.toString(((Node)list.get(i)).getIDVal())
					+ "V" + ", ";
			
			}
			
			
		}	
			

		if(((Node)list.get(list.size()-1)).getFixedJoint())
		{
			temp += "F" + "J" +
			Integer.toString(((Node)list.get(list.size()-1)).getIDVal())
			+ "H" + ", ";
			temp += "F" + "J" +
			Integer.toString(((Node)list.get(list.size()-1)).getIDVal()) + "V" +
			";\n";
		}
		else if(((Node)list.get(list.size()-1)).getGroundJoint())
				temp += "F" + "J" +
				Integer.toString(((Node)list.get(list.size()-1)).getIDVal()) +
				"V" + ";\n";
		else temp = temp.substring(0, (temp.length()-2)) + ";\n" ;
			


		temp += "joint ";
		
		for(int i = 0; i< (list.size()-1); i++)
		{
		
		temp += "J" + Integer.toString(((Node)list.get(i)).getIDVal()) + ", ";
		
		}
		
		temp += "J" +
		Integer.toString(((Node)list.get(list.size()-1)).getIDVal()) +
		";\n";


		
		temp += "constraints \n ESteel = 30000000;\n Sy = 30000;\n";

		temp += "Pi = 3.141; \n ";
		
		
		for(int i = 0; i < (barList.size()); i++)
		{
		
		temp += "W" + Integer.toString(((Bar)barList.get(i)).getIDVal()) + " = "
		+ "H" + Integer.toString(((Bar)barList.get(i)).getIDVal()) + ";" ;  
		}
		
		temp += "\n";
		
		temp += "constructors sampletruss(X) {\n";
		

		for(int i = 0; i < (barList.size()); i++)
		{
		barID = ((Bar)barList.get(i)).getID();
		
		temp += barID + " = " + "new bar(";
		
		temp += ((Bar)barList.get(i)).getValue("elasticity") + ", "; 
		temp += ((Bar)barList.get(i)).getValue("sy") + ", ";
		temp += ((Bar)barList.get(i)).getValue("length") + ", "; 
		temp += ((Bar)barList.get(i)).getValue("width") + ", ";
		temp += ((Bar)barList.get(i)).getValue("height") + ", "; 
		temp += ((Bar)barList.get(i)).getValue("f_bn") + ", ";
		temp += ((Bar)barList.get(i)).getValue("f_bk") + ", ";
		temp += ((Bar)barList.get(i)).getValue("f_t") + ", "; 
		temp += ((Bar)barList.get(i)).getValue("sigma") + ", ";
		temp += ((Bar)barList.get(i)).getValue("bar_i") + ", "; 
		temp += ((Bar)barList.get(i)).getValue("bar_f") + ");\n";
		
		}
		
		
		for(int i = 0; i< (list.size()); i++)
		{
		
		Node n = (Node)list.get(i);
		LinkedList e = n.edges;
		String spstr = "";
		String spstr2 = "";
		for(int j = 0; j < e.size(); j++)
		{

		String bID = ((Bar)e.get(j)).getID();
		String str1;
		
		
		str1 = "I" + bID ;
		
		for(int l = 0;l < tempList.size(); l++)
		{
		if(((String)tempList.get(l)).equals(str1))
		{
		
		str1 = "I" + bID.substring(1) + bID.substring(0,1);
		break;
		}
		
 		}
 		
 		tempList.add(str1);
 		
 		temp += str1 + " = " + "new beam( " + bID + ", " +
 		n.getAngle(bID) +
 		");\n";
 		
 		spstr += str1 + ", ";
 		
		}

	
		if(((Node)list.get(i)).getFixedJoint())
			{
				temp += "I" + "J" +
				Integer.toString(((Node)list.get(i)).getIDVal())
				+ "H" + " = new load(" + "F" + "J" +
				Integer.toString(((Node)list.get(i)).getIDVal()) + "H, 0);" ;
				
				temp += "I" + "J" +
				Integer.toString(((Node)list.get(i)).getIDVal())
				+ "V" + " = new load(" + "F" + "J" +
				Integer.toString(((Node)list.get(i)).getIDVal()) + "V, Pi/2);";
			
				spstr2 += "I" + "J" +
				Integer.toString(((Node)list.get(i)).getIDVal())
				+ "V" + ", ";

				spstr2 += "I" + "J" +
				Integer.toString(((Node)list.get(i)).getIDVal())
				+ "H" + ", ";

			
			
			}
		else
			{
				if(((Node)list.get(i)).getGroundJoint() &&
				(((Node)list.get(i)).getLoad()).equals(""))
					{
					
					temp += "I" + "J" +
				Integer.toString(((Node)list.get(i)).getIDVal())
				+ "V" + " = new load(" + "F" + "J" +
				Integer.toString(((Node)list.get(i)).getIDVal()) + "V, Pi/2);";
				
				spstr2 += "I" + "J" +
				Integer.toString(((Node)list.get(i)).getIDVal())
				+ "V" + ", ";
				
					}
					
				if(((Node)list.get(i)).getGroundJoint() &&
				!(((Node)list.get(i)).getLoad()).equals(""))
					{
					
					temp += "I" + "J" +
				Integer.toString(((Node)list.get(i)).getIDVal())
				+ "V" + " = new load(" + ((Node)list.get(i)).getLoad() + ", "
				+ ((Node)list.get(i)).getLoadAngle() + ");";
				
				spstr2 += "I" + "J" +
				Integer.toString(((Node)list.get(i)).getIDVal())
				+ "V" + ", ";
				
					}					
			}
			
				

		String x = Integer.toString(((Node)list.get(i)).getIDVal());
		
		temp += "BA" + x + " = [" + spstr;
				
		temp = temp.substring(0, (temp.length()-2)) + "];\n" ;
				
		temp += "L" + x + " = [  " + spstr2; 
		
		temp = temp.substring(0, (temp.length()-2)) + "];\n" ;
		
		temp += "J" + x + " = " + "new joint(BA" + x + ", " + "L" + x +");\n"; 
		}
		
		temp += "X = [" ;
		
		for(int i = 0; i < (barList.size()); i++)
		{
			String x = Integer.toString(((Bar)barList.get(i)).getIDVal());
			temp += "F" + x + ", ";	
		}	
		

		for(int i = 0; i< (list.size()); i++)
		{
			
			if(((Node)list.get(i)).getFixedJoint())
			{
				temp += "F" + "J" +
				Integer.toString(((Node)list.get(i)).getIDVal())
				+ "H" + ", ";
				temp += "F" + "J" +
				Integer.toString(((Node)list.get(i)).getIDVal())
				+ "V" + ", ";
			}
			else
			{
				if(((Node)list.get(i)).getGroundJoint())
					temp += "F" + "J" +
					Integer.toString(((Node)list.get(i)).getIDVal())
					+ "V" + ", ";
			
			}
			
			
		}	
			


		temp = temp.substring(0, (temp.length()-2)) + "];\n" ;
		
		temp += "\n}\n}\n\n$" ;
		
		
		
		trussText = trussText + temp;		
		System.out.println(temp);
		
		
		
		/*

		trussText += "class sampletruss { \n" +
  "attributes \n" +
    "bar AB, BC, CD, BD, AC; \n" +
    "beam IAB, IAC, IBA, IBC, IBD, ICA, ICB, ICD, IDB, IDC; \n" +
    "load IAV, IAH, ICV, IDV; \n" +
    "beam []  Ba, Bb, Bc, Bd; \n" +
    "load []  La, Lc, Ld; \n" +
    "Real Esteel, Sy, Pi; \n" +
    "Real W1, W2, W3, W4, W5, H1, H2, H3, H4, H5," +
        " Fab, Fbc, Fcd, Fbd, Fac, " +
       "  Fab_bk, Fbc_bk, Fcd_bk, Fbd_bk, Fac_bk," + 
        " Fab_bn, Fbc_bn, Fcd_bn, Fbd_bn, Fac_bn, " +
       "  Fab_t, Fbc_t, Fcd_t, Fbd_t, Fac_t," +
       "  Fdv, Fcv, Fav, Fah, " +
       "  Sigmaab, Sigmabc, Sigmacd, Sigmaac, Sigmabd," +
       "  Iab, Ibc, Icd, Ibd, Iac; \n" +
  Iab, Ibc, Icd, Ibd, Iac; \n: Command not found

   " joint JA, JB, JC, JD; \n\n" +
  "constraints \n" +
   " ESteel = 30000000; \n" +
   " Sy = 30000; \n" +
   " Pi = 3.141; \n" +
   " W1 = H1; W2 = H2; W3 = H3; W4 = H4; W5 = H5; \n" +
  "constructors sampletruss(X) { \n" +
   " AB = new bar(ESteel, Sy, 10.4, W1, H1, Fab_bn, Fab_bk, Fab_t, Sigmaab, Iab,"+
   " Fab); \n" +
   " BC = new bar(ESteel, Sy, 7.3, W2, H2, Fbc_bn, Fbc_bk, Fbc_t, Sigmabc, Ibc," +
   " Fbc); \n" +
   " CD = new bar(ESteel, Sy, 12.7, W3, H3, Fcd_bn, Fcd_bk, Fcd_t, Sigmacd, Icd," +
   " Fcd); \n" +
   " BD = new bar(ESteel, Sy, 14.7, W4, H4, Fbd_bn, Fbd_bk, Fbd_t, Sigmabd, Ibd," +
   " Fbd); \n" +
   " AC = new bar(ESteel, Sy, 7.3, W5, H5, Fac_bn, Fac_bk, Fac_t, Sigmaac, Iac," +
   " Fac); \n" +
   " IAB = new beam(AB, Pi/4); IAC = new beam(AC, 0); IAV = new load(Fav, Pi/2);" +
   " IAH = new load(Fah, 0); \n" +
   " Ba = [IAB, IAC]; La = [IAV, IAH]; \n" +
   " JA = new joint(Ba, La); \n" +
   " IBA = new beam(AB, 5*Pi/4); IBC = new beam(BC, 3*Pi/2); IBD = new beam(BD," +
   " 11*Pi/6); \n" +
   " Bb = [IBA, IBC, IBD]; Lb = []; \n" +
   " JB = new joint(Bb, Lb); \n" +
   " ICA = new beam(AC, Pi); ICB = new beam(BC, Pi/2); ICD = new beam(CD, 0); ICV" +
   " = new load(15000, 3*Pi/2); \n" +
   " Bc = [ICA, ICB, ICD]; Lc = [ICV]; \n" +
   " JC = new joint(Bc, Lc); \n" +
   " IDB = new beam(BD, 5*Pi/6); IDC = new beam(CD, Pi); IDV = new load(Fdv," +
   " Pi/2); \n" +
   " Bd = [IDB, IDC]; Ld = [IDV]; \n" +
   " JD = new joint(Bd, Ld); \n" +
   " X = [Fab, Fbc, Fcd, Fbd, Fac, Fav, Fah, Fdv]; \n\n" +
 " } \n" +
" } \n\n$\n";



*/
		
		System.out.println(trussText);
		        
        cobText = trussText;
        
    }
    
  /**
   * returns the Cob code. This is followed by the call to generateCode()
   */
    public String getCode(){
        return cobText;
    }

  /**
   * Identify the electrical components on the circuit drawn and categrizes them based on 
   * their type by forming list of the respective categories.
   */    
    public LinkedList identifyComponents(LinkedList list){
        nodeList = list;
        
        if(nodeList.isEmpty()) return null;
        
        for(int i=0; i<nodeList.size(); i++){
            LinkedList elist = (LinkedList)((Node)nodeList.get(i)).edges ;
            for(int j = 0; j<elist.size(); j++){
                Edge edg = (Edge)elist.get(j);
                if(edg.getID().startsWith("B")){
                    if(!barList.contains(edg)) barList.add(edg);
                }
                
            }//end for j
        }//end for i
        
        LinkedList listArray = barList;
        return listArray;
    }
  

  private String getBeamText()
  {

    String cText = "";
    
      cText += "      "+ "    A >= 0;   A <= 2* 180;" + "\n";    
    
    String text = "class beam{\n   attributes\n      bar B;\n      Real A;\n   constraints\n"+ cText+"   constructors beam(B1, A1){\n     B = B1; A = A1;\n   }\n}";
    return text;
  }

  private String getBarText()
  {
     String cText = "";
    
      cText += "      "+ "    I = F_bk * L *L /3.141 * 3.141*E; \n" +
    "I = W * H * H * H / 12; \n" +
    "F_t = (Sy * (W * H)); \n" +
    "Sigma = (((H * L) * F_bn )/ (8 * I)); \n" +
    "F_t = F :- F > 0; \n" +
    "F_bk = F :- F < 0;" + "\n";
    
    
    String text = "class bar{\n   attributes\n      Real E, Sy, L, W, H, F_bn," +
    "F_bk, F_t, Sigma, I, F;\n   constraints\n"+ cText+"   constructors " +
    "bar(E1,Sy1,L1,W1,H1,F_bn1,F_bk1,F_t1,Sigma1,I1,F1){\n      E=E1; Sy=Sy1;" +
    "L=L1; H=H1; W=W1; F_bn=F_bn1;\n      F_bk=F_bk1; F_t=F_t1; Sigma=Sigma1;" +
    "I=I1; F=F1;\n   }\n}";
    return text;
  }

  private String getJointText()
  {
    String cText = "";

      cText += "      "+ "    (sum X in Beams: (X.B.F * sin(X.A))) + sum X in " +
      "Loads: (X.F * sin(X.A)) = 0; \n" +
    "(sum X in Beams: (X.B.F * cos(X.A))) + sum X in Loads: (X.F * cos(X.A)) = 0;" + "\n";
      
    String text = "class joint{\n   attributes\n      beam[] Beams;\n      load[] " +
    "Loads;\n   constraints\n"+ cText+"   constructors joint(B1, L1){\n" +     
    "Beams = B1;\n      Loads = L1;\n      }\n}";
    return text;
  }

  private String getLoadText()
  {
  
    String cText = "";

	cText += "      "+ " A >= 0; A <= 2*180;" + "\n";
	
    String text = "class load{\n   attributes\n      Real F;\n      Real A;\n  " +
    "constraints\n"+cText+"   constructors load(F1, A1){\n      F =" +
    "F1;\n      A = A1;\n   }\n}";
    
    return text;
  }



  private String getDump()
  {


      String list = "";
      String text = "";
      int count= 0;
/*
      for(int i = 0; i < resistorList.size(); i++){
        Edge edg = (Edge)resistorList.get(i);
      	list += edg.getID()+",";
	list += edg.getCurrentID();
        count+=2;
	if( count > 5 )
	{
	   text += "       dump(["+ list +"]);\n" ;
	   count = 0;
	   list = "";
	}
	if((i!= resistorList.size()-1 || batteryList.size()>0 || wireList.size()>0 ) && count != 0)
	   list += ",";
      }
      for(int i = 0; i < batteryList.size(); i++) {
        Edge edg = (Edge)batteryList.get(i);
      	list += edg.getID()+",";
	list += edg.getCurrentID();	
        count+=2;
	if( count > 5 )
	{
	   text += "       dump(["+ list +"]);\n" ;
	   count = 0;
	   list = "";
	}
	if( (i!= batteryList.size()-1 || wireList.size()>0) && count != 0)
	   list += ",";
      }
      for(int i = 0; i < wireList.size(); i++) {
        Edge edg = (Edge)wireList.get(i);
	list += edg.getCurrentID();	
        count+=1;
	if( count > 5 )
	{
	   text += "       dump(["+ list +"]);\n" ;
	   count = 0;
	   list = "";
	}
	if(i!= wireList.size()-1  && count != 0)
	   list += ",";
      }

*/
      if(!list.equals("")) text += "       dump(["+ list +"]);\n" ;

      return text ;	
  }
  
  


}

class TestPane extends javax.swing.JTextPane
{
    String filename = "startpic3g_b.gif";
    java.awt.Image pic = java.awt.Toolkit.getDefaultToolkit().getImage(filename);

    public void paintComponent(java.awt.Graphics g) {
        super.paintComponent(g);
        g.drawImage(pic, 0, 0, this);
    }
}



