/*
 * CobHelp.java
 *
 * Created on Feb 20, 2002, 5:31 PM
 */

package cse605;

/**
 *
 * @author  adev
 * @version 
 */
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.util.*;
import java.lang.*;
import javax.swing.text.*;

class CobHelp
{
    public static final int TOOL = 2334 ;
    public static final int AUTHOR = 8745 ;
    public static final int DRAW = 8275 ;
    public static final int CONSTRAINTS = 82 ;
    public static final int RUN = 422 ;
    public static final int DEBUG = 234 ;
    public static final int SAVE = 641 ;
    public static final int LOAD = 145 ;
    public static final int TROUBLE = 932;    
    public static void showHelp(int type)
    {
	 JOptionPane.showMessageDialog(null,getText(type),"Help", JOptionPane.PLAIN_MESSAGE);
    }
    
    private static String getText(int type)
    {
        String text = "";
	switch(type){
	 case TOOL:
	     text += "The Truss v2.1 has been developed\n" +
	     "to demonstrate the capability of\nConstraint Object Language (COB). The\n" +
	     "COB code is generated based on circuit\n" +
	     "drawn and inputs provided by the user\n" +
	     "on the tool. The COB code is then\n" +
	     "translated to CLP(R) which then is\n" +
	     "executed to solve the constraints in\nthe system.";
	     break;
	 case AUTHOR:
	     text += "CREDITS\n\nConcept:\n        Dr. Bharat Jayaraman\n       " +
	     "(bharat@cse.buffalo.edu)\n\nDevelopment:\n              Kapil Gajria &" +
	     "Srivatsava Shanker\n " +
	     "      (kpgajria@cse.buffalo.edu)\n\nReferences:\n        Cob Code " +
	     "      Generator by Abhilash Dev & Narayan Menon\n" + 
	     "       (nmenon@cse.buffalo.edu)\n\nCOB Translator:\n" +
	     "       Pallavi Tambay\n        (tambay@cse.buffalo.edu)";
	     break;
	 case DRAW:
	     text += "Drawing Truss:\n\nThe Truss can be drawn on the\n" +
	     "editor window'     'Truss'.\nUsing the Beam button on the left side" +
	     "the\ncorresponding beam\ncomponents can be placed on the\n" +
	     "canvas. These components can be\njoined at their nodes to form a\n" +
	     "rm a\ntruss by dragging and pulling\nthe components from their center\n" +
	     "and from their edges.";
	     break;
	 case CONSTRAINTS:
	     text += "Putting Constraints:\n\n" +
	     "The input constraints on any\ncomponent can be provided at the\n" +
	     "time when its being placed on to\nthe canvas. These can be fed into\n" +
	     "the input window that pops up\nwhen the new component is placed.\n" +
	     "\nThe constraints can also be\nmodified by right-clicking on the\n" +
	     "center of the component for which\n" +
	     "constraints have to be modified.\n\n" +
	     "The Instance constraint refers to\n" +
	     "the constraint on a particular\n" +
	     "beam on the\ntruss\n\n" +
	     "The Type constraint refers to the\n" +
	     "constraints on the Component type\n" +
	     "and will apply to all the\ninstances of that type. \n" +
	     "\ne.g. N1.V - N2.V = I * R is the\n" +
	     "constraint on all the Resistor\ncomponents." + 
	     "Changing this will\naffect all the resistors on the\ncircuit";
	     break;
	 case RUN:
	     text = "Running Code:\n\n1. In order to run the code after\n" +
	     "truss has been drawn, go to\n   Tools on the menu" +
	     "and click on\n   'compile'. The user is asked for the \n" +
	     "load and angle input.The truss is seen\n" +
	     " blinking. After this, again go\n   to Tools Menu" +
	     " and click on\n   'run'. This should run the code\n" +
	     " and switch to the Results\n   Window.\n\n" +
	     " If an error message is seen,\n   refer to" +
	     " help on trouble-\n   shooting.\n\n2. The" +
	     " overall results are listed\n   under the" +
	     " truss. ";
	     break;
	 case DEBUG:
	     text += "Debugging:\n\nIn order to check the generated\n" +
	     "COB Code and CLP(R) code, go to\n'Code' Window\n\n" +
	     "In order to check the Prolog and\n" +
	     "CLP(R) outputs, go to 'Diagnose'\nwindow\n  \n" +
	     "In order to view these windows\nalong with Truss or Results\n" +
	     "windows, go to 'view' menu  and\n" +
	     "click on 'Eject'. This pops up\n" +
	     "'Code' or 'Diagnose' Window as a\nseparate window. You can now go\n" +
	     "to any window on the tool.";
	     break;
	 case SAVE:
	     text += "Saving:\n\nCircuit:" + 
	     "Truss can be saved by\nclicking " +
	     "'Save' in 'File' menu.\nThe extension for the " +
	     "file is .trs\nThe truss can be saved only from\n" +
	     "the editor window 'Truss'\n\nCOB code can also be " + 
	     "saved as .cob\nfile. This can be done by clicking \n" +
	     "'Save' under 'File' menu. This can\nbe done only " +
	     "from the 'Code'\nwindow.";
	     break;
	 case LOAD:
	     text += "Loading Truss:\n\n" +
	     "Previously stored truss can be\n" +
	     "loaded by clicking 'Open' under\n'File' " +
	     "menu and by selecting the\nappropriate .trs file.";
	     break;
	 case TROUBLE:
	     text += "Troubleshooting:\n\n" +
	     "Most of the errors that you can encounter " +
	     "have to \ndo with the paths specified in " +
	     "config file 'cob.cfg'.\nCheck this file for " +
	     "all the paths listed\n\nIf the application " +
	     "crashes and core dumps then update\n" +
	     "the Java runtime environment on your " +
	     "computer or\ncheck the solaris patches" +
	     "(for Sun workstation).\nThe application " +
	     "has been tested with v 1.3.1 of Java\n\n" +
	     "If the problem doesn't get solved you can " +
	     "contact\nKapil Gajria(kpgajria@cse.buffalo.edu) " +
	     "even though he\nmay not respond to the problems " +
	     "with this tool !";
	     break;
	 default:
	}
	return text;
    }

}
