/**
 * CodeTracer.java
 *
 * Created on Nov 20, 2001, 2:52 PM
 */

package cse605;

/**
 *
 * @author  adev
 * @version 
 */
 
import java.util.*;
import javax.swing.JTextArea;
import javax.swing.JScrollPane;
import javax.swing.JFrame;
import javax.swing.*;
import javax.swing.text.*;
import java.awt.*;

class CodeTracer extends JPanel
{
   private String prologOutput;
   private String clprOutput;
   private JPanel poPane;
   private JPanel coPane;
   private JTextPane poTPane;
   private JTextPane coTPane;
   private Color bgColor = Color.black;
      
   public CodeTracer(String po, String co)
   {
   	super();
	prologOutput = po;
	clprOutput = co;
	
	setLayout( new GridLayout(1,2) );

	poTPane = getTextPane(prologOutput, Color.cyan);
	poTPane.setBackground(bgColor);
 	poPane = new JPanel();
	poPane.setLayout( new BorderLayout() );
	poPane.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
	poPane.setBorder(BorderFactory.createTitledBorder("Prolog Output"));
	poPane.add( new JScrollPane(poTPane), BorderLayout.CENTER );

	coTPane = getTextPane(clprOutput, Color.green);
	coTPane.setBackground(bgColor);
 	coPane = new JPanel();
	coPane.setLayout( new BorderLayout() );
	coPane.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
	coPane.setBorder(BorderFactory.createTitledBorder("Clpr Output"));
	coPane.add(new JScrollPane(coTPane), BorderLayout.CENTER );
	add(poPane);
	add(coPane);
   }

  /**
   *  returns the JTextPane for the text passed as argument
   */   
   public static JTextPane getTextPane(String text, Color textColor)
   {
       Font font = CobLib.font;
       JTextPane tp = new JTextPane();
       tp.setEditable(false);
       Document doc = tp.getDocument();
       try {
          int len = doc.getLength();
          doc.remove(0,len);
       }
       catch (BadLocationException ble) {
          System.err.println("Couldn't insert initial text.");
       }
       
       MutableAttributeSet attr = new SimpleAttributeSet();
       StyleConstants.setFontFamily (attr, font.getFamily());
       StyleConstants.setFontSize (attr, font.getSize());
       StyleConstants.setBold (attr, font.isBold());
       StyleConstants.setItalic (attr, font.isItalic());
       StyleConstants.setForeground(attr, textColor);              
       tp.setCharacterAttributes(attr, false);

       try{
          doc.insertString(doc.getLength(), text, attr );
       }
       catch (BadLocationException ble) {
          System.err.println("Couldn't insert initial text.");
       }
       return tp;
   }
   
   
   
   /**
   * updates all the four codes and returns the handle to the itself
   */
   public JPanel update(String po, String co)
   {
	prologOutput = po;
	clprOutput = co;
 	poTPane.setText(prologOutput);
 	coTPane.setText(clprOutput);
	return this;
   }
   
   /**
   * changes the background color of all the four windows displaying texts
   */
   public void changeBgColor(Color c)
   {
   	poTPane.setBackground(c);
   	coTPane.setBackground(c);
	bgColor = c;
   }
}
