package cse605;
public class DrawingFilter extends javax.swing.filechooser.FileFilter {

   /**
    * Returns true if the file is a directory or its name ends with
    * .dgr
    *
    * @param f the file in question
    * @return true if the file is a directory or its name ends 
    * with ".drg"
    *
    */
   public boolean accept(java.io.File f) {
      if ( f != null ) {
	 return f.isDirectory() ||
	    f.getName().endsWith(".trs");
      } // end of if ()
      return false;
   }

   /**
    * Returns the textual description of the filter.
    *
    * @return the textual description of the filter.
    */
   public String getDescription() {
      return "Electrical Circuit (*.trs)";
   }
}// drawingFilter


