/*
 * CobCode.java
 *
 * Created on May 6, 2001, 2:22 AM
 */

package cse605;

/**
 *
 * @author  adev
 * @version 
 */
import java.util.*;
import javax.swing.JTextArea;
import javax.swing.JScrollPane;
import javax.swing.JFrame;
import javax.swing.*;
import javax.swing.text.*;

public class CobCode extends Object {


    //private String nodeText;
    //private String resistorText;
    //private String wireText;
    //private String batteryText;
  
  	private String barText;
  	private String beamText;
  	private String loadText;
  	private String jointText;
  	
    private LinkedList wireList, resistorList, batteryList, nodeList;

    private String cobText = "";

    /** Creates new CobCode */
    public CobCode() {
        wireList = new LinkedList();
        resistorList = new LinkedList();
        batteryList = new LinkedList();        
    }
    
    public void clearAll()
    {
        wireList = new LinkedList();
        resistorList = new LinkedList();
        batteryList = new LinkedList();
        nodeList = new LinkedList();
    }

    public void generateCode(LinkedList list){

        //nodeText = getNodeText();
        //resistorText = getResistorText();
        //wireText = getWireText();
        //batteryText = getBatteryText();
      
      	barText = getBarText();
      	beamText = getBeamText();
      	jointText = getJointText();
      	loadText = getLoadText();
      	
      	/*
        if(list.size()>0) identifyComponents(list);

        String nodeAmps ="";
        String constraintText = "";
        
        String circuitText = "";
        
        
        String newWiresText="";
        String newResistorsText="";
        String newBatteriesText="";
        String newNodesText="";

		*/
		
		
        //circuitText+= nodeText+"\n\n\n\n"+resistorText+"\n\n\n\n"+wireText+"\n\n\n\n"+batteryText+"\n\n\n\n";

		String trussText = "";
		
        trussText+=
        barText+"\n\n\n\n"+beamText+"\n\n\n\n"+jointText+"\n\n\n\n"+loadText+"\n\n\n\n";

		trussText += "class sampletruss { \n" +
  "attributes \n" +
    "bar AB, BC, CD, BD, AC; \n" +
    "beam IAB, IAC, IBA, IBC, IBD, ICA, ICB, ICD, IDB, IDC; \n" +
    "load IAV, IAH, ICV, IDV; \n" +
    "beam []  Ba, Bb, Bc, Bd; \n" +
    "load []  La, Lc, Ld; \n" +
    "Real Esteel, Sy, Pi; \n" +
    "Real W1, W2, W3, W4, W5, H1, H2, H3, H4, H5," +
        " Fab, Fbc, Fcd, Fbd, Fac, " +
       "  Fab_bk, Fbc_bk, Fcd_bk, Fbd_bk, Fac_bk," + 
        " Fab_bn, Fbc_bn, Fcd_bn, Fbd_bn, Fac_bn, " +
       "  Fab_t, Fbc_t, Fcd_t, Fbd_t, Fac_t," +
       "  Fdv, Fcv, Fav, Fah, " +
       "  Sigmaab, Sigmabc, Sigmacd, Sigmaac, Sigmabd," +
       "  Iab, Ibc, Icd, Ibd, Iac; \n" +
   " joint JA, JB, JC, JD; \n\n" +
  "constraints \n" +
   " ESteel = 30000000; \n" +
   " Sy = 30000; \n" +
   " Pi = 3.141; \n" +
   " W1 = H1; W2 = H2; W3 = H3; W4 = H4; W5 = H5; \n" +
  "constructors sampletruss(X) { \n" +
   " AB = new bar(ESteel, Sy, 10.4, W1, H1, Fab_bn, Fab_bk, Fab_t, Sigmaab, Iab,"+
   " Fab); \n" +
   " BC = new bar(ESteel, Sy, 7.3, W2, H2, Fbc_bn, Fbc_bk, Fbc_t, Sigmabc, Ibc," +
   " Fbc); \n" +
   " CD = new bar(ESteel, Sy, 12.7, W3, H3, Fcd_bn, Fcd_bk, Fcd_t, Sigmacd, Icd," +
   " Fcd); \n" +
   " BD = new bar(ESteel, Sy, 14.7, W4, H4, Fbd_bn, Fbd_bk, Fbd_t, Sigmabd, Ibd," +
   " Fbd); \n" +
   " AC = new bar(ESteel, Sy, 7.3, W5, H5, Fac_bn, Fac_bk, Fac_t, Sigmaac, Iac," +
   " Fac); \n" +
   " IAB = new beam(AB, Pi/4); IAC = new beam(AC, 0); IAV = new load(Fav, Pi/2);" +
   " IAH = new load(Fah, 0); \n" +
   " Ba = [IAB, IAC]; La = [IAV, IAH]; \n" +
   " JA = new joint(Ba, La); \n" +
   " IBA = new beam(AB, 5*Pi/4); IBC = new beam(BC, 3*Pi/2); IBD = new beam(BD," +
   " 11*Pi/6); \n" +
   " Bb = [IBA, IBC, IBD]; Lb = []; \n" +
   " JB = new joint(Bb, Lb); \n" +
   " ICA = new beam(AC, Pi); ICB = new beam(BC, Pi/2); ICD = new beam(CD, 0); ICV" +
   " = new load(15000, 3*Pi/2); \n" +
   " Bc = [ICA, ICB, ICD]; Lc = [ICV]; \n" +
   " JC = new joint(Bc, Lc); \n" +
   " IDB = new beam(BD, 5*Pi/6); IDC = new beam(CD, Pi); IDV = new load(Fdv," +
   " Pi/2); \n" +
   " Bd = [IDB, IDC]; Ld = [IDV]; \n" +
   " JD = new joint(Bd, Ld); \n" +
   " X = [Fab, Fbc, Fcd, Fbd, Fac, Fav, Fah, Fdv]; \n\n" +
 " } \n" +
" } \n\n$\n";

/*		We comment the circuit text from here,
		To be implemented later.

        circuitText+= "class circuit{\n   attributes\n      node ";
        for(int i=0; i< nodeList.size(); i++)
        {
	    circuitText+="N"+((Node)nodeList.get(i)).nodeID;
            if(i!=nodeList.size()-1) circuitText +=",";
            nodeAmps+="N"+((Node)nodeList.get(i)).nodeID+"amps";
            if(i!=nodeList.size()-1) nodeAmps +=",";
            newNodesText+="      N"+((Node)nodeList.get(i)).nodeID +" = new node("+"N"+((Node)nodeList.get(i)).nodeID+"amps,V"+((Node)nodeList.get(i)).nodeID+");\n";
        }
	
	if( resistorList.size() >0 )
            circuitText+=";\n      resistor ";

        for(int i=0; i< resistorList.size(); i++)
        {
            Edge e = (Edge)resistorList.get(i);
            Node[] ns = e.getNodes();
            circuitText+=((Edge)resistorList.get(i)).getID()+"x";
            if(i!=resistorList.size()-1) circuitText +=",";

	    String[] cArray = ((Edge)resistorList.get(i)).getInstanceConstraint();
	    for(int j=0; j<cArray.length; j++)
	      constraintText+="\n       "+cArray[j];
	      
	    if( ! ((String)e.getCurrentID()).equals(e.getCurrent()))
	    {
	       constraintText+="\n       "+e.getCurrentID()+" = "+e.getCurrent() +";";
	    }
            constraintText+="\n       "+e.getID()+" = "+e.getValue() +";";

            newResistorsText+="      "+e.getID()+"x = new resistor(N"+ns[1].nodeID+",N"+ns[0].nodeID+","+e.getCurrentID()+","+e.getID()+");\n";
        }

	if( wireList.size() >0 )
	    circuitText+=";\n      wire ";
        for(int i=0; i< wireList.size(); i++)
        {
            Edge e = (Edge)wireList.get(i);
            Node[] ns = e.getNodes();
            circuitText+=((Edge)wireList.get(i)).getID()+"x";
            if(i!=wireList.size()-1) circuitText +=",";

	    String[] cArray = ((Edge)wireList.get(i)).getInstanceConstraint();
	    for(int j=0; j<cArray.length; j++)
	      constraintText+="\n       "+cArray[j];

	    if( ! ((String)e.getCurrentID()).equals(e.getCurrent()))
	    {
	       constraintText+="\n       "+e.getCurrentID()+" = "+e.getCurrent() +";";
	    }

            newWiresText+="      "+e.getID()+"x = new wire(N"+ns[1].nodeID+",N"+ns[0].nodeID+","+e.getCurrentID()+");\n";
        }

	if( batteryList.size() >0 )
	    circuitText+=";\n      battery ";
        for(int i=0; i< batteryList.size(); i++)
        {
            Edge e = (Edge)batteryList.get(i);
            Battery b = (Battery)e;
            Node[] ns = e.getNodes();
            circuitText+=e.getID()+"x";
            if(i!=batteryList.size()-1) circuitText +=",";

	    String[] cArray = ((Edge)batteryList.get(i)).getInstanceConstraint();
	    for(int j=0; j<cArray.length; j++)
	      constraintText+="\n       "+cArray[j];

	    if( ! ((String)e.getCurrentID()).equals(e.getCurrent()))
	    {
	       constraintText+="\n       "+e.getCurrentID()+" = "+e.getCurrent() +";";
	    }
            constraintText+="\n       "+e.getID()+" = "+e.getValue() +";";

            if(b.positiveNode.equals("L"))
                newBatteriesText+="      "+e.getID()+"x = new battery(N"+ns[1].nodeID+",N"+ns[0].nodeID+","+e.getID()+");\n";
            else if(b.positiveNode.equals("R"))
                newBatteriesText+="      "+e.getID()+"x = new battery(N"+ns[0].nodeID+",N"+ns[1].nodeID+","+e.getID()+");\n";

        }
	
        constraintText+="\n"+getDump();


	// check if there are instance constraints 
	if( new StringTokenizer(constraintText).hasMoreTokens() )
            circuitText+=";\n      Real [] "+nodeAmps+";\n constraints\n"+constraintText;
	else 
	    circuitText+=";\n      Real [] "+nodeAmps+";\n";
	    
	    
        circuitText+=" constructors circuit(X){\n";
        for(int i=0; i< nodeList.size(); i++)
        {
            Node n= (Node)nodeList.get(i);
            for(int j=0; j< n.currents.length; j++)
            {
                circuitText+="      N"+n.nodeID+"amps["+(j+1)+"]="+n.currents[j]+";\n";
            }
            circuitText+="\n";
        }
        circuitText+=newNodesText+"\n";
        circuitText+=newBatteriesText+"\n";
        circuitText+=newResistorsText+"\n";
        circuitText+=newWiresText+"\n";
        circuitText+="\n   }\n}\n\n\n";

*/
		
		System.out.println(trussText);
		        
        cobText = trussText;
        
    }
    
  /**
   * returns the Cob code. This is followed by the call to generateCode()
   */
    public String getCode(){
        return cobText;
    }

  /**
   * Identify the electrical components on the circuit drawn and categrizes them based on 
   * their type by forming list of the respective categories.
   */    
    public LinkedList[] identifyComponents(LinkedList list){
        nodeList = list;
        if(nodeList.isEmpty()) return null;
        
        for(int i=0; i<nodeList.size(); i++){
            LinkedList elist = (LinkedList)((Node)nodeList.get(i)).edges ;
            for(int j = 0; j<elist.size(); j++){
                Edge edg = (Edge)elist.get(j);
                if(edg.getID().startsWith("R")){
                    if(!resistorList.contains(edg)) resistorList.add(edg);
                }
                else if(edg.getID().startsWith("B")){
                    if(!batteryList.contains(edg)) batteryList.add(edg);
                }
                else{
                    if(!wireList.contains(edg)) wireList.add(edg);
                }
            }//end for j
        }//end for i
        
        LinkedList[] listArray = {resistorList, batteryList, wireList};
        return listArray;
    }
  
/*

  private String getNodeText()
  {
    LinkedList list =  Node.getConstraints();
    String cText = "";
    for(int i=0; i< list.size(); i++)
      cText += "      "+ (String)list.get(i) + "\n";
    String text = "class node{\n   attributes\n      Real V;\n      real [] Current;\n   constraints\n"+ cText+"   constructors node(Curr, V1){\n      Current = Curr;\n      V = V1;\n   }\n}";
    return text;
  }

  private String getResistorText()
  {
    LinkedList list =  Resistor.getConstraints();
    String cText = "";
    for(int i=0; i< list.size(); i++)
      cText += "      "+ (String)list.get(i) + "\n";
    String text = "class resistor{\n   attributes\n      Real I,R;\n      node N1,N2;\n   constraints\n"+ cText+"   constructors resistor(Na, Nb, I1, R1){\n      N1 = Na;\n      N2 = Nb;\n      I = I1;\n      R = R1;\n   }\n}";
    return text;
  }

  private String getWireText()
  {
    LinkedList list =  Wire.getConstraints();
    String cText = "";
    for(int i=0; i< list.size(); i++)
      cText += "      "+ (String)list.get(i) + "\n";

    String text = "class wire{\n   attributes\n      Real I;\n      node N1,N2;\n   constraints\n"+ cText+"   constructors wire(Na, Nb, I1){\n      N1 = Na;\n      N2 = Nb;\n      I = I1;\n   }\n}";
    return text;
  }

  private String getBatteryText()
  {
    LinkedList list =  Battery.getConstraints();
    String cText = "";
    for(int i=0; i< list.size(); i++)
      cText += "      "+ (String)list.get(i) + "\n";

    String text = "class battery{\n   attributes\n      Real B;\n      node N1, N2;\n   constraints\n"+cText+"   constructors battery(Na,Nb,B1){\n      N1 = Na;\n      N2 = Nb;\n      B = B1;\n   }\n}";
    return text;
  }

*/


  private String getBeamText()
  {

    // To be implemented later, when we form the Bar.java class


    //LinkedList list =  Node.getConstraints();
    String cText = "";
    //for(int i=0; i< list.size(); i++)
      //cText += "      "+ (String)list.get(i) + "\n";
    
      cText += "      "+ "    0 <= A;   A <= 2* 180;" + "\n";    
    
    String text = "class beam{\n   attributes\n      bar B;\n      Real A;\n   constraints\n"+ cText+"   constructors beam(B1, A1){\n     B = B1; A = A1;\n   }\n}";
    return text;
  }

  private String getBarText()
  {
    // To be implemented later, when we form the Bar.java class
    
    //LinkedList list =  Resistor.getConstraints();
    String cText = "";
    //for(int i=0; i< list.size(); i++)
      //cText += "      "+ (String)list.get(i) + "\n";
    
      cText += "      "+ "    I = F_bk * L *L /3.141 * 3.141*E; \n" +
    "I = W * H * H * H / 12; \n" +
    "F_t = (Sy * (W * H)); \n" +
    "Sigma = (((H * L) * F_bn )/ (8 * I)); \n" +
    "F_t = F :- F > 0; \n" +
    "F_bk = F :- F < 0;" + "\n";
    
    
    String text = "class bar{\n   attributes\n      Real E, Sy, L, W, H, F_bn," +
    "F_bk, F_t, Sigma, I, F;\n   constraints\n"+ cText+"   constructors " +
    "bar(E1,Sy1,L1,W1,H1,F_bn1,F_bk1,F_t1,Sigma1,I1,F1){\n      E=E1; Sy=Sy1;" +
    "L=L1; H=H1; W=W1; F_bn=F_bn1;\n      F_bk=F_bk1; F_t=F_t1; Sigma=Sigma1;" +
    "I=I1; F=F1;\n   }\n}";
    return text;
  }

  private String getJointText()
  {
    // To be implemented later, when we form the Joint.java class
 
     //LinkedList list =  Wire.getConstraints();
    String cText = "";
    //for(int i=0; i< list.size(); i++)
      //cText += "      "+ (String)list.get(i) + "\n";

      cText += "      "+ "    (sum X in Beams: (X.B.F * sin(X.A))) + sum X in " +
      "Loads: (X.F * sin(X.A)) = 0; \n" +
    "(sum X in Beams: (X.B.F * cos(X.A))) + sum X in Loads: (X.F * cos(X.A)) = 0;" + "\n";
      
    String text = "class joint{\n   attributes\n      beam[] Beams;\n      load[] " +
    "Loads;\n   constraints\n"+ cText+"   constructors joint(B1, L1){\n" +     
    "Beams = B1;\n      Loads = L1;\n      }\n}";
    return text;
  }

  private String getLoadText()
  {
  
    // To be implemented later, when we form the Load.java class
  
    //LinkedList list =  Load.getConstraints();
    String cText = "";
    //for(int i=0; i< list.size(); i++)
      //cText += "      "+ (String)list.get(i) + "\n";

	cText += "      "+ " 0 <= A; A <= 2*180;" + "\n";
	
    String text = "class load{\n   attributes\n      Real F;\n      Real A;\n  " +
    "constraints\n"+cText+"   constructors load(F1, A1){\n      F =" +
    "F1;\n      A = A1;\n   }\n}";
    
    return text;
  }



  private String getDump()
  {
      String list = "";
      String text = "";
      int count= 0;
      for(int i = 0; i < resistorList.size(); i++){
        Edge edg = (Edge)resistorList.get(i);
      	list += edg.getID()+",";
	list += edg.getCurrentID();
        count+=2;
	if( count > 5 )
	{
	   text += "       dump(["+ list +"]);\n" ;
	   count = 0;
	   list = "";
	}
	if((i!= resistorList.size()-1 || batteryList.size()>0 || wireList.size()>0 ) && count != 0)
	   list += ",";
      }
      for(int i = 0; i < batteryList.size(); i++) {
        Edge edg = (Edge)batteryList.get(i);
      	list += edg.getID()+",";
	list += edg.getCurrentID();	
        count+=2;
	if( count > 5 )
	{
	   text += "       dump(["+ list +"]);\n" ;
	   count = 0;
	   list = "";
	}
	if( (i!= batteryList.size()-1 || wireList.size()>0) && count != 0)
	   list += ",";
      }
      for(int i = 0; i < wireList.size(); i++) {
        Edge edg = (Edge)wireList.get(i);
	list += edg.getCurrentID();	
        count+=1;
	if( count > 5 )
	{
	   text += "       dump(["+ list +"]);\n" ;
	   count = 0;
	   list = "";
	}
	if(i!= wireList.size()-1  && count != 0)
	   list += ",";
      }

      if(!list.equals("")) text += "       dump(["+ list +"]);\n" ;

      return text ;	
  }
  
  


}

class TestPane extends javax.swing.JTextPane
{
    String filename = "startpic3g_b.gif";
    java.awt.Image pic = java.awt.Toolkit.getDefaultToolkit().getImage(filename);

    public void paintComponent(java.awt.Graphics g) {
        super.paintComponent(g);
        g.drawImage(pic, 0, 0, this);
    }
}



