/*
 * DrawingUtility.java
 *
 * Created on May 10, 2001, 3:48 AM
 */

package cse605;

/**
 *
 * @author  adev
 * @version 
 */
import java.util.*;
import javax.swing.*;
import java.awt.geom.*;
import java.awt.*;
import java.awt.font.*;
public final class DrawingUtility extends Object {

    public static void showVals(float X1, float Y1, float X2, float Y2, Graphics2D g2, String val){

        int fontStyle = Font.ITALIC ;
        FontRenderContext frc = g2.getFontRenderContext();
        Font f = new Font("Times", fontStyle, 11);
        StringTokenizer st = new StringTokenizer(val);
        String s1,s2 = " ";
        if(st.countTokens()>1){
            s1 = st.nextToken();
            s2 = st.nextToken();
        }
        else s1 = st.nextToken();

        TextLayout t1 = new TextLayout(s1, f, frc);
        TextLayout t2 = new TextLayout(s2, new Font("Times", Font.PLAIN, 11), frc);

        
        int count = 0;
        int dl = 6;
        final double alpha = Math.toRadians(45.0);
        double phi = Math.atan((Y2-Y1)/(X2-X1)) ;
        double dist = Math.sqrt( Math.pow((X1-X2),2) + Math.pow((Y1-Y2),2) );
        GeneralPath path = new GeneralPath();
        float x=(float)(X1+ 0.25*dist);
        float y=Y1;
        path.moveTo(x,y);

        float _x= (float)(x - dl*Math.cos(alpha));
        float _y= (float)(y - dl*Math.sin(alpha));
        path.lineTo(_x,_y);
        path.lineTo(x,y);
        _y =  (float)(y + dl*Math.sin(alpha));
        path.lineTo(_x,_y);
        path.lineTo(x,y);
        
        AffineTransform at = new AffineTransform() ;
        at.rotate(phi,X1,Y1);
        Shape dirShape  =  at.createTransformedShape(path) ;
        Shape valShape  =  at.createTransformedShape( t1.getOutline(null) );
        Shape wireShape  =  at.createTransformedShape( t2.getOutline(null) );
        g2.setColor(new Color(68,141,31));
        g2.draw(dirShape);
        g2.transform(at);
        float xpos = (float)(X1 + 0.25*dist);
        float ypos = Y1 + 15;
        t1.draw(g2, xpos, ypos);

        g2.setColor(Color.darkGray);
        xpos = (float)(X1 + 0.4*dist);
        ypos = Y1 - 15;
        t2.draw(g2, xpos, ypos);

        
        try{
            g2.transform( at.createInverse() );
        }
        catch( NoninvertibleTransformException nte)
        {
            System.out.println("problems with graphics");
        }
    }

    public static void showID(float X1, float Y1, float X2, float Y2, Graphics2D g2, TextLayout tl)
    {
        double phi = Math.atan((Y2-Y1)/(X2-X1)) ;
        double dist = Math.sqrt( Math.pow((X1-X2),2) + Math.pow((Y1-Y2),2) );

        AffineTransform _at = new AffineTransform() ;
        _at.rotate(phi,X1,Y1);
        g2.transform(_at);
	
        float xpos = (float)(X1 + 0.4*dist);
        float ypos = (float)(Y1 - 15);
        g2.setColor(Color.blue);
        tl.draw(g2, xpos, ypos );
	
        try{
            g2.transform( _at.createInverse() );
        }
        catch( NoninvertibleTransformException nte)
        {
            System.out.println("problems with graphics");
        }
    }


    public static void drawResistor(float X1, float Y1, float X2, float Y2, Graphics2D g2){
        int count = 0;
        final int dx = 2;
        final int dy = 3;
        final double alpha = Math.toRadians(75.0);
        double phi = Math.atan((Y2-Y1)/(X2-X1)) ;
        double dist = Math.sqrt( Math.pow((X1-X2),2) + Math.pow((Y1-Y2),2) );
        GeneralPath path = new GeneralPath();
        float x=X1;
        float y=Y1;
        path.moveTo(x,y);
        x+=(float)(0.3*dist);
        y=Y1;
        path.lineTo(x,y);
        do{
            x+=dx;
            y=Y1+dy ;
            path.lineTo(x,y);
            x+=dx;
            y=Y1 ;
            path.lineTo(x,y);
            x+=dx;
            y=Y1-dy ;
            path.lineTo(x,y);
            x+=dx;
            y=Y1 ;
            path.lineTo(x,y);
            count++;
        }while(x<X1+0.7*dist && count < 35);
        x = X1+(float)dist;
        y = Y1;
        path.lineTo(x,y);
        AffineTransform at = new AffineTransform() ;
        at.rotate(phi,X1,Y1);    
        Shape resShape  =  at.createTransformedShape(path) ;
        g2.draw(resShape);
/*	
        Shape textShape = at.createTransformedShape(tl.getOutline(null));
        AffineTransform _at = new AffineTransform() ;
        _at.rotate(phi,X1,Y1);    
        g2.transform(_at);
        float xpos = (float)(X1 + 0.4*dist);
        float ypos = (float)(Y1 - 12);
        g2.setColor(Color.blue);
        tl.draw(g2, xpos, ypos );
        try{
            g2.transform( _at.createInverse() );
        }
        catch( NoninvertibleTransformException nte)
        {
            System.out.println("problems with graphics");
        }
*/	
    }

    public static void drawBattery(float X1, float Y1, float X2, float Y2, Graphics2D g2, String dir){
        int count = 0;
        final int h = 12;
        final int ds = 8;
        int dh;
        double phi = Math.atan((Y2-Y1)/(X2-X1)) ;
        double dist = Math.sqrt( Math.pow((X1-X2),2) + Math.pow((Y1-Y2),2) );

        if(dir.equals("L")) dh = h;
        else dh = (int)(h/2);

        GeneralPath path1 = new GeneralPath();
        path1.moveTo(X1,Y1);
        float x = X1;
        x+=(float)((dist-ds)/2);
        path1.lineTo(x,Y1);
        path1.lineTo(x,Y1+dh);
        path1.lineTo(x,Y1-dh);
        AffineTransform at = new AffineTransform() ;
        at.rotate(phi,X1,Y1);
        Shape batShape1  =  at.createTransformedShape(path1) ;
//        g2.draw(batShape1);

        if(dir.equals("R")) dh = h;
        else dh = (int)(h/2);

        x+=(float)((ds)/2);
        GeneralPath path2 = new GeneralPath();
        path2.moveTo(x,Y1+dh);
        path2.lineTo(x,Y1-dh);
        path2.lineTo(x,Y1);
        x = (float)(X1+dist);
        path2.lineTo(x,Y1);
        AffineTransform at2 = new AffineTransform() ;
        at2.rotate(phi,X1,Y1);
        Shape batShape2  =  at2.createTransformedShape(path2) ;
        GeneralPath gp = new GeneralPath(batShape1);
        gp.append(batShape2, false);
        g2.draw(gp);
/*
        Shape textShape = at.createTransformedShape(tl.getOutline(null));
        AffineTransform _at = new AffineTransform() ;
        _at.rotate(phi,X1,Y1);
        g2.transform(_at);
        float xpos = (float)(X1 + 0.4*dist);
        float ypos = (float)(Y1 - 15);
        g2.setColor(Color.blue);
        tl.draw(g2, xpos, ypos );
        try{
            g2.transform( _at.createInverse() );
        }
        catch( NoninvertibleTransformException nte)
        {
            System.out.println("problems with graphics");
        }
*/	

    }
    
    
    public static void drawBeam(float X1, float Y1, float X2, float Y2,
    Graphics2D g2){
        int count = 0;
        final int dx = 2;
        final int dy = 3;
        final double alpha = Math.toRadians(75.0);
        double phi = Math.atan((Y2-Y1)/(X2-X1)) ;
        double dist = Math.sqrt( Math.pow((X1-X2),2) + Math.pow((Y1-Y2),2) );
        GeneralPath path = new GeneralPath();
        float x=X1;
        float y=Y1;
        path.moveTo(x,y);
        x+=(float)(0.3*dist);
        y=Y1;
        path.lineTo(x,y);
        do{
            x+=dx;
            y=Y1+dy ;
            path.lineTo(x,y);
            x+=dx;
            y=Y1 ;
            path.lineTo(x,y);
            x+=dx;
            y=Y1-dy ;
            path.lineTo(x,y);
            x+=dx;
            y=Y1 ;
            path.lineTo(x,y);
            count++;
        }while(x<X1+0.7*dist && count < 35);
        x = X1+(float)dist;
        y = Y1;
        path.lineTo(x,y);
        AffineTransform at = new AffineTransform() ;
        at.rotate(phi,X1,Y1);    
        Shape resShape  =  at.createTransformedShape(path) ;
        g2.draw(resShape);

    }
    

}
