/*
 * Memento.java
 *
 * Created on April 28, 2001, 3:48 AM
 */

package cse605;

/**
 *
 * @author  adev
 * @version 
 */
import java.util.*;
import javax.swing.*;
import java.io.*;

public class Memento extends Observable implements Serializable
{
    private Stack mementos = new Stack();
    private Stack forward = new Stack();
    
    public Memento(Observer obs){
        addObserver(obs);
    }
    
    public LinkedList getPrevious(){
        LinkedList list = (LinkedList)mementos.pop();
        LinkedList flist = new LinkedList();
        for(int i=0; i<list.size(); i++) flist.add(list.get(i)) ;
        forward.push(flist);
        setChanged() ;
//        System.out.println("go back");
        notifyObservers() ;
        LinkedList temp = (LinkedList)mementos.peek();
        LinkedList returnList = new LinkedList();
        for(int i=0; i<temp.size(); i++) returnList.add( temp.get(i) ) ;
        return returnList;
    }
    
    public void put(LinkedList list){
        forward.clear();
        mementos.push(list);
        setChanged() ;
        notifyObservers() ;
    }

    public LinkedList getNext(){
        LinkedList list = (LinkedList)forward.pop();
        LinkedList blist = new LinkedList();
        for(int i=0; i<list.size(); i++) blist.add(list.get(i)) ;
        mementos.push(blist);
        setChanged() ;
//        System.out.println("Sending notification");
        notifyObservers() ;
        return list;
    }
    
    public void putNext(LinkedList list){
        forward.push(list);
        setChanged() ;
        notifyObservers() ;
    }

    public void clearAll()
    {
        mementos.clear();
        forward.clear();
        setChanged() ;
        notifyObservers() ;        
    }
    public boolean isBackable(){
        if(mementos.size()>1) return true;
        else return false;
    }

    public boolean isForwardable(){
        return !forward.isEmpty();
    }

/*
    public static Canvas getPrevious(){
//        System.out.println("getting previous state back : "+ mementos.peek().getClass().getName());
        return (Canvas)mementos.pop();
    }
    public static void put(Canvas can){
        JFrame frame = new JFrame();
        frame.setContentPane(can);
        frame.setSize(300,300);
        frame.setVisible(true);
        mementos.push(can);
    }
*/
}
