package cse250.examples.debugging;
/*
 * cse250.examples.debugging.FarmersMarket.java
 * 
 * Copyright 2023 Oliver Kennedy (okennedy@buffalo.edu)
 *           2023 Eric Mikida (epmikida@buffalo.edu)
 *           2021 Andrew Hughes (ahughes6@buffalo.edu)
 *
 * This work is licensed under the Creative Commons
 * Attribution-NonCommercial-ShareAlike 4.0 International License.
 * To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/4.0/.
 *
 */

import java.net.URL;
import java.net.MalformedURLException;

class FarmersMarket
{
  String name;
  double lat;
  double lon;
  URL website;
  boolean sellsBakedGoods;
  
  public FarmersMarket(String input)
    throws MalformedURLException
  {
    String[] columns = input.split(",");
    this.name = columns[1];
    this.lat = Double.parseDouble(columns[21]);
    this.lon = Double.parseDouble(columns[22]);
    this.website = new URL(columns[2]);
    this.sellsBakedGoods = (columns[27] == "Y");
  }
}