package cse250.examples.speeddemo;

import java.util.List;
import java.util.LinkedList;
import java.util.ArrayList;
import java.util.Random;

class SpeedDemo
{

  static Random rand = new Random();


  public static void main(String args[])
  {

    // Try a variety of data sizes:
    //    10^3 = 1000, 
    //    10^4 = 10000, 
    //    10^5 = 100000, 
    //    etc...
    for(int exp = 3; exp <= 7; exp++)
    {
      System.out.println("");

      // Size = 10^exponent
      long size = (long)Math.pow(10, exp);

      // Make and initialize the data structure
      //List<Integer> arr = makeLinkedList(size);
      List<Integer> arr = makeArray(size);

      System.out.println("Trying a "+arr.getClass().getSimpleName()+" containing 10^"+exp+" = "+arr.size()+" elements");

      // And time the result
      timeLotsOfLookups(arr);
    }
    System.out.println("");
  }


  /**
   * Test the access cost for the provided List
   * @param data      The list to test
   * 
   * This test will time how long it takes to complete 10k lookups
   */
  public static void timeLotsOfLookups(List<Integer> data)
  {
    // Measure time with System.currentTimeMillis()
    long startTime = System.currentTimeMillis();

    // If you don't actually save the result, Java may optimize the
    // (unnecessary) computations away.
    long total = 0;

    // 10k times...
    for(int i = 0; i < 10000; i++)
    {
      // Pick a random position in the dataset and retrieve it.
      total += data.get(rand.nextInt(data.size()));
    }

    // End the timer
    long endTime = System.currentTimeMillis();

    // And log the result
    System.out.println("                                    ... took: "+(endTime - startTime)+" ms");
  }

  /**
   * Construct an ArrayList populated with placeholder data
   */
  public static ArrayList<Integer> makeArray(long size)
  {
    // Make the array list
    ArrayList<Integer> ret = new ArrayList<Integer>();

    // And populate each position with an arbitrary value
    for(int i = 0; i < size; i++){ ret.add(i); }

    return ret;
  }

  /**
   * Construct an LinkedList populated with placeholder data
   */
  public static LinkedList<Integer> makeLinkedList(long size)
  {
    // Make the linked list
    LinkedList<Integer> ret = new LinkedList<Integer>();

    // And populate each position with an arbitrary value
    for(int i = 0; i < size; i++){ ret.add(i); }

    return ret;
  }

}