package cse250.examples;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;

public class Main {
    static Random rand = new Random();
    public static void bubbleSort(List<Integer> list) {
        for (int i = list.size() - 2; i >= 0; i--) {
            for (int j = i; j < list.size() - 1; j++) {
                if(list.get(j) < list.get(j+1)) {
                    Integer tmp = list.get(j);
                    list.set(j, list.get(j+1));
                    list.set(j+1, tmp);
                }
            }
        }
    }
    public static void main(String[] args) {
        for(int exp = 5; exp <= 15; exp++) {
            System.out.println("");

            // Size = 10^exponent
            long size = (long)Math.pow(2, exp);

            // Make and initialize the data structure
            //List<Integer> list = createRandomLinkedList(size);
            List<Integer> list = createRandomArray(size);

            System.out.println("Trying a " + list.getClass().getSimpleName() + " containing 10^"+exp+" = " + list.size()+" elements");

            // And time the result
            long startTime = System.currentTimeMillis();
            bubbleSort(list);
            long endTime = System.currentTimeMillis();
            System.out.println("                                   ... took: "+(endTime - startTime)+" ms");
        }
        System.out.println("");
    }

    public static List<Integer> createRandomArray(long size) {
        List<Integer> list = new ArrayList();
        for (int i = 0; i < size; i++) {
            list.add(rand.nextInt());
        }
        return list;
    }

    public static List<Integer> createRandomLinkedList(long size) {
        List<Integer> list = new LinkedList();
        for (int i = 0; i < size; i++) {
            list.add(rand.nextInt());
        }
        return list;
    }
}
