package cse250.examples.debugging;
/*
 * cse250.examples.debugging.BreakItDown.scala
 *
 * Copyright 2023 Oliver Kennedy (okennedy@buffalo.edu)
 *           2023 Eric Mikida (epmikida@buffalo.edu)
 *           2021 Andrew Hughes (ahughes6@buffalo.edu)
 *
 * This work is licensed under the Creative Commons
 * Attribution-NonCommercial-ShareAlike 4.0 International License.
 * To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/4.0/.
 *
 */

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;

class BreakItDown
{
  /**
   * Read the dataset, dropping the header
   */
  public static ArrayList<String> readData(String file)
    throws IOException
  {
    ArrayList<String> ret = new ArrayList<>();

    BufferedReader reader = 
      new BufferedReader(
        new FileReader(file)
      );

    // Drop the header from the file
    reader.readLine();

    // Read lines one at a time
    String line;
    while((line = reader.readLine()) != null)
    {
      ret.add(line);
    }

    return ret;
  }

  /**
   * Count the number of markets that sell baked goods
   */
  public static int countTheBakedGoods(ArrayList<FarmersMarket> markets)
  {
    int count = 0;
    for(FarmersMarket market : markets)
    {
      if(market.sellsBakedGoods) { count += 1; }
    }
    return count;
  }

  /**
   * Read the Farmer's markets
   * @param file
   * @return
   */
  public static ArrayList<FarmersMarket> readMarkets(String file)
    throws MalformedURLException, IOException
  {
    ArrayList<String> data =
            readData(file);

    // Drop the header
    data.remove(0);

    // Parse out the farmers market details
    ArrayList<FarmersMarket> markets = new ArrayList<>();
    for(String line : data)
    {
      markets.add(new FarmersMarket(line));
    }

    return markets;
  }

  public static void main(String[] args)
    throws IOException {

    ArrayList <FarmersMarket> markets =
      readMarkets("AMS-USDA-Directories-FarmersMarkets.csv");
    // This should print out 75
    System.out.println("A total of "+countTheBakedGoods(markets)+" farmers markets sell baked goods!");
  }
}