package cse250.examples.flipside;

import java.util.*;

public class Main {
    public static List<String> adjacencyList(String vertex) {
        List<String> adj = new ArrayList<>(9);
        for (int i = 0; i < 3; i++) {
            for (int j = 0; j < 3; j++) {
                String topleft = vertex.substring(0,i);
                String top = vertex.substring(i,i+3);
                String topright = vertex.substring(i+3,5);

                String botleft = vertex.substring(5,j+5);
                String bot = vertex.substring(j+5,j+8);
                String botright = vertex.substring(j+8,10);

                adj.add(topleft + bot + topright + botleft + top + botright);
            }
        }
        return adj;
    }
    public static void main(String[] args) {
        String start = "6341852079";
        String end = "0123456789";
        System.out.println("Finding a path from " + start + " to " + end);

        //Queue<String> todo = new LinkedList<>();
        Stack<String> todo = new Stack<>();
        Map<String, String> edgeTo = new HashMap<>();
        edgeTo.put(start, start);
        todo.add(start);

        while (!todo.isEmpty()) {
            String curr = todo.pop();
            for (String to : adjacencyList(curr)) {
                if (!edgeTo.containsKey(to)) {
                    edgeTo.put(to, curr);
                    todo.add(to);
                    if (to.equals(end)) {
                        System.out.println("FOUND IT!");
                        todo.clear();
                        break;
                    }
                }
            }
        }

        List<String> path = new LinkedList<>();
        String curr = end;
        while (curr != start) {
            path.add(0, curr);
            curr = edgeTo.get(curr);
        }
        path.add(0, curr);
        System.out.println(path);
    }
}