package cse250.examples.debugging;
/*
 * cse250.examples.debugging.FarmersMarket.java
 * 
 * Copyright 2023 Oliver Kennedy (okennedy@buffalo.edu)
 *           2023 Eric Mikida (epmikida@buffalo.edu)
 *           2021 Andrew Hughes (ahughes6@buffalo.edu)
 *
 * This work is licensed under the Creative Commons
 * Attribution-NonCommercial-ShareAlike 4.0 International License.
 * To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/4.0/.
 *
 */

import java.net.URL;
import java.net.MalformedURLException;

public class FarmersMarket {
  public String name;
  public double lat;
  public double lon;
  public URL website;
  public boolean sellsBakedGoods;

  /**
   * Create a FarmersMarket object from a string read from a CSV file
   * @param input a string read from a CSV file containing the farmers market data
   * @throws MalformedURLException
   */
  public FarmersMarket(String input) throws MalformedURLException {
    String[] columns = input.split(",");
    name = columns[1];
    lat = Double.parseDouble(columns[17]);
    lon = Double.parseDouble(columns[18]);
    website = new URL(columns[2]);
    sellsBakedGoods = (columns[27] == "Y");
  }
}