package cse250.examples.debugging;
/*
 * cse250.examples.debugging.BreakItDown.java
 *
 * Copyright 2023 Oliver Kennedy (okennedy@buffalo.edu)
 *           2023 Eric Mikida (epmikida@buffalo.edu)
 *           2021 Andrew Hughes (ahughes6@buffalo.edu)
 *
 * This work is licensed under the Creative Commons
 * Attribution-NonCommercial-ShareAlike 4.0 International License.
 * To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/4.0/.
 *
 */

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import java.util.ArrayList;

public class FileProcessor {
  /**
   * Read the dataset, dropping the header
   * @param filename the name of the CSV file to read
   * @return a list of lines in the file
   */
  public static List<String> readLines(String filename) throws IOException {
    ArrayList<String> ret = new ArrayList<>();
    BufferedReader reader = new BufferedReader(new FileReader(filename));

    // The file should contain a header line; drop it
    reader.readLine();

    String line;
    while((line = reader.readLine()) != null) {
      ret.add(line);
    }

    return ret;
  }

  /**
   * Read in farmer's market data from a CSV file
   * @param filename the name of the CSV file containing the data
   * @return a list of FarmersMarket objects
   */
  public static List<FarmersMarket> readMarkets(String filename) throws IOException {
      List<String> lines = readLines(filename);

      // The file should contain a header so drop the first line
      lines.remove(0);

      List<FarmersMarket> markets = new ArrayList<>();
      for (String line : lines) {
          markets.add(new FarmersMarket(line));
      }

      return markets;
  }

  /**
   * Count the number of markets that sell baked goods
   * @param markets a list of FarmersMarket objects
   * @return the number of FarmersMarkets in the list that sell baked goods
   */
  public static int countTheBakedGoods(List<FarmersMarket> markets) {
    int count = 0;
    for(FarmersMarket market : markets) {
      if(market.sellsBakedGoods) { count += 1; }
    }
    return count;
  }

  public static void main(String[] args) throws IOException {
    List<FarmersMarket> markets = readMarkets("AMS-USDA-Directories-FarmersMarkets.csv");

    // This should print out 75
    System.out.println("A total of "+countTheBakedGoods(markets)+" farmers markets sell baked goods!");
  }
}