## All the bugs

#### BreakItDown

`FarmersMarket.java` lines 32,33 should read:
```java
    this.lat = Double.parseDouble(columns[18]);
    this.lon = Double.parseDouble(columns[19]);
```

Until this bug is fixed, you'll get a number format exception on the first line.

Key things to point out in the process of "finding" this bug:
* Exceptions are really helpful for tracking down bugs: Note especially the complaint "Number Format" and 'For Input String "Y"'.  
* Also note the line number: Farmer's market line 32.
* Open up the AMS csv file and look: "Y" is several columns right.  Count out the correct number of columns

---


`FarmersMarket.java` line 35 should read:
```java
    if(columns[2].equals("")){ this.website = null; }
      else                   { this.website = new URL(columns[2]); }
```

Until this bug is fixed, you'll get a malformed URL exception for markets with `""` as a website.

Key things to point out in the process of "finding" this bug:
* This exception is not quite as helpful... there's no text.
* This is a good time to go into the debugger.  When the code crashes, what's the state of the variable.  e.g., what's `columns[2]`

---

`FarmersMarket.java` line 37 should read:
```java
    this.sellsBakedGoods = (columns[27].equals("Y"));
```

Until this bug is fixed, you'll get a count that is always 0.

This is a bit of a hidden bug, but one to emphasize: `==` in java tests for referential equality, not logical equality.  Two instances of the same string will fail `==`.

Key things to point out in the process of "finding" this bug:
* Exploring state in the debugger is helpful.  
* Establish assertions and see if they're correct.  E.g., 0 means that *no* farmer's markets sell baked goods.  
   * Check if we have the right column?  (yes we do)
   * Set a breakpoint in the debugger.  is `columns[27]` `"Y"`?  (yes it is)
   * Narrow in on the specific point of the problem.

---

`BreakItDown` line 64 OR line 35 should be deleted

Until this bug is fixed, you'll get a count that is too low by 1.

Key things to point out in the process of "finding" this bug:
* Add breakpoints and checks: How many records are in 'data'; How many records are in the CSV file?
* Document all assumptions!
* Not every bug results in an exception!
