## All the bugs

This small demo was adapted from the previous debugging demo about Farmer's Markets, but with a slightly simpler dataset

`Pokemon.java` lines 11 should read:
```java
    number = Integer.parseInt(columns[0]);
```

Until this bug is fixed, you'll get a number format exception on line 11. The subsequent lines (12,13, and 14) need to
be adjusted as well to refer to indices 1, 2 and 3 respectively.

Key things to point out in the process of "finding" this bug:
* Exceptions are really helpful for tracking down bugs.  
* Also note the line number: Pokemon.java line 11.
* We can set a breakpoint and see the state of columns when the crash occurs.
* We can also open up the csv file to corroborate what we see in the debugger.
* Note that not all errors will result in an Exception being thrown.
  * If we don't fix lines 12-14 everything will still run but we'll get unexpected results

---

`FileProcessor.java` line 64 should read:
```java
    if(p.type1.equals(type) || p.type2.equals(type)) { count += 1; }
```

There are actually two bugs here. The first is that the original code uses == for string comparison. Until this bug is fixed, you'll get a count that is always 0.

This is a bit of a hidden bug, but one to emphasize: `==` in java tests for referential equality, not logical equality.  Two instances of the same string will fail `==`.

Key things to point out in the process of "finding" this bug:
* Just because it doesn't crash doesn't mean our code is *correct*
* Exploring state in the debugger is helpful.
* Don't just ignore warnings.
* Establish assertions and see if they're correct.  E.g., 0 means that *no* pokemon have the specified type.

The second bug related to this line is that the check originally only checks type1. This will result in a smaller number than expected.

Key things to point out here:
* Make small, manageable tests to zero in on the bug
  * The whole pokemon.csv file is very large, and it can take a while using the debugger to sift through lines to find something unexpected
  * Instead, make a small focused test, ie using pokemon_small.csv to help you zero in on what is working and what isn't

---

`FileProcessor.java` line 26 OR line 45 should be deleted

Until this bug is fixed, you'll get a count that is too low by 1.

Key things to point out in the process of "finding" this bug:
* Add breakpoints and checks: How many records are in 'data'; How many records are in the CSV file?
* Document all assumptions!
* Not every bug results in an exception!
* Just like above, this will likely be easier to find with a smaller, more focused test
