package cse250.examples.debugging;
/*
 * cse250.examples.debugging.FileProcessor.java
 *
 * This simple example defines a class to read a list of Pokémon from a CSV file and
 * count the number of Pokémon that have a given type.
 */

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import java.util.ArrayList;

public class FileProcessor {
  /**
   * Read the dataset, dropping the header
   * @param filename the name of the CSV file to read
   * @return a list of lines in the file
   */
  public static List<String> readLines(String filename) throws IOException {
    ArrayList<String> ret = new ArrayList<>();
    BufferedReader reader = new BufferedReader(new FileReader(filename));

    // The file should contain a header line; drop it
    reader.readLine();

    String line;
    while((line = reader.readLine()) != null) {
      ret.add(line);
    }

    return ret;
  }

  /**
   * Read in Pokémon data from a CSV file
   * @param filename the name of the CSV file containing the data
   * @return a list of {@link Pokemon} objects
   */
  public static List<Pokemon> readPokemon(String filename) throws IOException {
      List<String> lines = readLines(filename);

      // The file should contain a header so drop the first line
      lines.remove(0);

      List<Pokemon> pokemon = new ArrayList<>();
      for (String line : lines) {
          pokemon.add(new Pokemon(line));
      }

      return pokemon;
  }

  /**
   * Count the number of Pokémon in a given list that have the specified type
   * @param pokemon a list of {@link Pokemon} objects
   * @param type the type of Pokémon to count
   * @return the number of Pokémon in the {@code pokemon} that have the type {@code type}
   */
  public static int countType(List<Pokemon> pokemon, String type) {
    int count = 0;
    for(Pokemon p : pokemon) {
      if(p.type1 == type) { count += 1; }
    }
    return count;
  }

  public static void main(String[] args) throws IOException {
    List<Pokemon> pokemon = readPokemon("data/pokemon.csv");

    System.out.println("A total of "+countType(pokemon, "Water")+" Pokemon have the best type (water)!");
  }
}