package Interfaces;

public class Clark {

	
	
	/*Always declare as private so no one has access to
	 *your instance variables.  (Think of Clark's flailing arms)
	 *We declare our ClassType as the interface type so we can
	 * use differnt forms of Transportation.
	*/
	
	private Transport _myRide;
	public Clark() {
		
		/*Skateboard implements the interface "Transport", therefore
		 * we can store an instance of skateboard in the variable
		 * _myRide.
		 */
		_myRide = new Skateboard();
		
		/*The interface Transport has the accelerate method
		 *so _myRide.accelerate(new Velocity(7)) is a legal 
		 *method call.
		 */
		_myRide.accelerate(new Velocity(7));
		
		/*Transport doesn't however have the method entitled
		 * doTrick().  Therefore it is illegal to call that 
		 * method, because we declared our variable as an instance
		 * of our Interace.
		 * 
		 * If we had declared the variable type as Skateboard
		 * then we would be able to do tricks, but we would not
		 * be able to reassign our variable in the next bit of code.
		 */
		_myRide.doTrick(new KickFlip()); //This is illegal
		
		//Let's stop skating and get in the car.
		 _myRide = new Car();
		 
		 /*This reassignment is legal, because Car also implements
		  * the Transport interface.
		  */
		
	}

}
