/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.cse.green.editor.action;

import edu.buffalo.cse.green.GreenException;
import edu.buffalo.cse.green.PlugIn;
import edu.buffalo.cse.green.editor.DiagramEditor;
import edu.buffalo.cse.green.editor.action.Submenu;
import edu.buffalo.cse.green.editor.model.AbstractModel;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ContextAction
extends Action {
    protected ISelectionProvider _selectionProvider;
    protected IJavaElement _element;
    protected AbstractModel _model;
    public static final char EDITOR_INCREMENTAL_EXPLORATION = 'i';
    public static final char EDITOR_CHANGE_SIZE = 's';
    public static final char EDITOR_REFACTOR_MOVE = 'v';
    public static final char EDITOR_REFACTOR_RENAME = 'r';
    public static final char EDITOR_UNLOAD_TYPE = '\b';
    public static final int CM_TYPE = 1;
    public static final int CM_FIELD = 2;
    public static final int CM_METHOD = 4;
    public static final int CM_NOTE = 8;
    public static final int CM_RELATIONSHIP = 16;
    public static final int CM_EDITOR = 32;
    public static final int CM_MEMBER = 7;
    public static final int CM_ALL = 63;

    protected final DiagramEditor getEditor() {
        if (this._selectionProvider == null) {
            if (DiagramEditor.getActiveEditor() == null) {
                return DiagramEditor.getEditors().get(0);
            }
            return DiagramEditor.getActiveEditor();
        }
        return (DiagramEditor)this._selectionProvider;
    }

    public ContextAction() {
        this.setText(this.getLabel());
        this.setId(((Object)((Object)this)).getClass().getName());
    }

    public ContextAction(Object obj) {
        this.setId(((Object)((Object)this)).getClass().getName());
    }

    public void setSelectionProvider(ISelectionProvider selectionProvider) {
        this._selectionProvider = selectionProvider;
    }

    public abstract String getLabel();

    public final void run() {
        this.setContents();
        if (this.getSupportedModels() != 63 && (this._model == null || (this._model.getContextMenuFlag() & this.getSupportedModels()) == 0)) {
            GreenException.errorDialog("The desired action is not currently available");
            return;
        }
        BusyIndicator.showWhile((Display)this.getEditor().getSite().getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                try {
                    ContextAction.this.doRun();
                }
                catch (JavaModelException e) {
                    e.printStackTrace();
                }
            }
        });
        IActionBars bars = this.getEditor().getEditorSite().getActionBars();
        IContributionItem[] iContributionItemArray = bars.getToolBarManager().getItems();
        int n = 0;
        int n2 = iContributionItemArray.length;
        while (n < n2) {
            IContributionItem item = iContributionItemArray[n];
            if (item instanceof ActionContributionItem) {
                ActionContributionItem aItem = (ActionContributionItem)item;
                ContextAction action = (ContextAction)aItem.getAction();
                action.setEnabled(action.isEnabled());
            }
            ++n;
        }
    }

    public void setContents() {
        if (this.getEditor().getContext() != null) {
            this._element = this.getEditor().getContext().getElement();
            this._model = this.getEditor().getContext().getModel();
        } else {
            this._element = null;
            this._model = null;
        }
    }

    protected abstract void doRun() throws JavaModelException;

    protected abstract int getSupportedModels();

    public abstract boolean isEnabled();

    public boolean isVisible(AbstractModel model) {
        return (model.getContextMenuFlag() & this.getSupportedModels()) != 0;
    }

    public final String getGroup() {
        return this.getPath().toString();
    }

    public List<String> getSubMenuLabels() {
        ArrayList<String> labels = new ArrayList<String>();
        if (this.getGroup().equals(Submenu.None.toString())) {
            return labels;
        }
        labels.add(PlugIn.getSubMenuLabel(this.getGroup()));
        return labels;
    }

    public boolean isAvailableForBinary() {
        return false;
    }

    public abstract Submenu getPath();

    protected final String getMessage() {
        return null;
    }

    public ActionFactory getGlobalActionHandler() {
        GreenException.illegalOperation();
        return null;
    }

    public boolean isBinary() {
        this.setContents();
        if (this._element == null) {
            return true;
        }
        if (this._element.getElementType() == 7) {
            return ((IType)this._element).isBinary();
        }
        return ((IType)this._element.getAncestor(7)).isBinary();
    }

    public void calculateEnabled() {
        this.setContents();
        this.setEnabled(this.isEnabled());
    }
}

