/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.cse.green.editor.controller;

import edu.buffalo.cse.green.GreenException;
import edu.buffalo.cse.green.PlugIn;
import edu.buffalo.cse.green.editor.DiagramEditor;
import edu.buffalo.cse.green.editor.action.OpenElementAction;
import edu.buffalo.cse.green.editor.controller.PropertyChange;
import edu.buffalo.cse.green.editor.controller.PropertyListener;
import edu.buffalo.cse.green.editor.controller.RootPart;
import edu.buffalo.cse.green.editor.controller.policies.DeleteEditPolicy;
import edu.buffalo.cse.green.editor.model.AbstractModel;
import edu.buffalo.cse.green.editor.model.RootModel;
import edu.buffalo.cse.green.editor.model.commands.DeleteCommand;
import java.beans.PropertyChangeEvent;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutListener;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editpolicies.ResizableEditPolicy;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPart
extends AbstractGraphicalEditPart {
    protected final IFigure createFigure() {
        IFigure f = this.doCreateFigure();
        this.setFigure(f);
        f.setVisible(this.model().isVisible());
        this.updateColors(f);
        this.initialize();
        f.addLayoutListener(new LayoutListener(){

            public void invalidate(IFigure container) {
            }

            public boolean layout(IFigure container) {
                return false;
            }

            public void postLayout(IFigure container) {
            }

            public void remove(IFigure child) {
            }

            public void setConstraint(IFigure child, Object constraint) {
                AbstractPart.this.model().setDrawnSize(child.getPreferredSize());
            }
        });
        return f;
    }

    private AbstractModel<?, ?, ?> model() {
        return (AbstractModel)this.getModel();
    }

    public boolean equals(Object o) {
        if (o instanceof AbstractPart) {
            AbstractPart part = (AbstractPart)((Object)o);
            return this.model().equals(part.getModel());
        }
        return false;
    }

    public List<AbstractPart> getChildren() {
        List pChildren = super.getChildren();
        if (pChildren == null || pChildren.isEmpty()) {
            return new ArrayList<AbstractPart>();
        }
        return (ArrayList)pChildren;
    }

    public AbstractPart getPartFromModel(AbstractModel model) {
        return this.getRootPart().getPartFromModel(model);
    }

    protected List getModelChildren() {
        return this.model().getChildren();
    }

    public final void propertyChange(PropertyChangeEvent evt) {
    }

    public void activate() {
        if (this.getParent() != null && this.getParent().isActive() && !this.isActive()) {
            super.activate();
            this.addListener(PropertyChange.Children, new ChildAndVisualsUpdater());
            this.addListener(PropertyChange.Location, new VisualsUpdater());
            this.addListener(PropertyChange.Refresh, new Refresher());
            this.addListener(PropertyChange.Size, new VisualsUpdater());
            this.addListener(PropertyChange.Visibility, new VisibilityUpdater());
            this.addPropertyListeners();
        }
    }

    protected abstract void addPropertyListeners();

    protected void addListener(PropertyChange kind, PropertyListener listener) {
        this.model().addListener(kind, listener);
    }

    public void deactivate() {
        if (this.isActive()) {
            super.deactivate();
        }
    }

    protected final void updateVisuals() {
        if (Display.getCurrent() != null) {
            this.refreshVisuals();
            this.updateColors(this.getFigure());
        } else {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    AbstractPart.this.refreshVisuals();
                    AbstractPart.this.updateColors(AbstractPart.this.getFigure());
                }
            });
        }
    }

    protected final void updateChildren() {
        if (Display.getCurrent() != null) {
            this.refreshChildren();
        } else {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    AbstractPart.this.refreshChildren();
                }
            });
        }
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new DeleteEditPolicy(this));
    }

    public abstract DeleteCommand getDeleteCommand();

    public RootPart getRootPart() {
        return ((AbstractPart)this.getParent()).getRootPart();
    }

    public RootModel getRootModel() {
        return (RootModel)this.getRootPart().getModel();
    }

    public void performRequest(Request req) {
        if (req.getType().equals("open")) {
            this.onDoubleClick();
        }
    }

    protected abstract void onDoubleClick();

    public DiagramEditor getEditor() {
        return this.getRootPart().getEditor();
    }

    protected Action getOpenElementAction() {
        OpenElementAction action = new OpenElementAction();
        action.setSelectionProvider(this.getEditor());
        return action;
    }

    protected final IFigure generateFigure() {
        Constructor<?>[] constructor = PlugIn.getViewPart(((Object)((Object)this)).getClass()).getConstructors();
        if (constructor.length != 1 || constructor[0].getParameterTypes().length != 0) {
            GreenException.illegalOperation("Wrong number of constructors or parameters. The class must have one constructor with no parameters.\nClass: " + PlugIn.getViewPart(((Object)((Object)this)).getClass()));
        }
        try {
            return (IFigure)constructor[0].newInstance(new Object[0]);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            return null;
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected abstract void updateColors(IFigure var1);

    protected abstract IFigure doCreateFigure();

    public EditPolicy generateResizableEditPolicy() {
        return new ResizableEditPolicy();
    }

    public abstract void setInitialBackgroundColor();

    public void setSelectedBackgroundColor() {
        Color selectedColor = PlugIn.getColorPreference("color.selected");
        this.getFigure().setBackgroundColor(selectedColor);
    }

    public void initialize() {
    }

    class ChildAndVisualsUpdater
    implements PropertyListener {
        ChildAndVisualsUpdater() {
        }

        public void notify(Object oValue, Object nValue) {
            AbstractPart.this.updateChildren();
            AbstractPart.this.updateVisuals();
        }
    }

    class Refresher
    implements PropertyListener {
        Refresher() {
        }

        public void notify(Object oValue, Object nValue) {
            AbstractPart.this.getFigure().validate();
            AbstractPart.this.updateVisuals();
        }
    }

    class VisibilityUpdater
    implements PropertyListener {
        VisibilityUpdater() {
        }

        public void notify(Object oValue, Object nValue) {
            AbstractPart.this.getFigure().setVisible(nValue.equals(true));
            AbstractPart.this.updateChildren();
            AbstractPart.this.updateVisuals();
        }
    }

    class VisualsUpdater
    implements PropertyListener {
        VisualsUpdater() {
        }

        public void notify(Object oValue, Object nValue) {
            AbstractPart.this.updateVisuals();
        }
    }
}

