/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.cse.green.editor.controller;

import edu.buffalo.cse.green.PlugIn;
import edu.buffalo.cse.green.editor.controller.JavadocGrabber;
import edu.buffalo.cse.green.editor.controller.MemberPart;
import edu.buffalo.cse.green.editor.controller.RootPart;
import edu.buffalo.cse.green.editor.controller.policies.GreenSelectionEditPolicy;
import edu.buffalo.cse.green.editor.model.FieldModel;
import edu.buffalo.cse.green.editor.model.commands.DeleteCommand;
import edu.buffalo.cse.green.editor.model.commands.DeleteFieldCommand;
import edu.buffalo.cse.green.editor.view.IIconHolder;
import java.util.AbstractList;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPolicy;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Display;

public class FieldPart
extends MemberPart {
    protected IFigure doCreateFigure() {
        IIconHolder iFigure = (IIconHolder)this.generateFigure();
        iFigure.setText(this.model().getDisplayName());
        iFigure.setIcon(this.model().getIcon());
        iFigure.setFont(PlugIn.getFontPreference("font", false, false));
        RootPart root = this.getRootPart();
        root.mapModelToEditPart(this.model(), this);
        iFigure.setOpaque(true);
        return iFigure;
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("Selection Feedback", (EditPolicy)new GreenSelectionEditPolicy());
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        this.figure().setText(this.model().getDisplayName());
    }

    public DeleteCommand getDeleteCommand() {
        return new DeleteFieldCommand(this.model());
    }

    public void updateIcon() {
        this.getViewer().getControl().getDisplay().asyncExec(new Runnable(){

            public void run() {
                FieldPart.this.figure().setIcon(FieldPart.this.model().getIcon());
            }
        });
    }

    protected void onDoubleClick() {
        this.getOpenElementAction().run();
    }

    private FieldModel model() {
        return (FieldModel)this.getModel();
    }

    private IIconHolder figure() {
        return (IIconHolder)this.getFigure();
    }

    public void updateFont() {
        if (Display.getCurrent() != null) {
            this.updateFontHelper();
        } else {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    FieldPart.this.updateFontHelper();
                }
            });
        }
    }

    private void updateFontHelper() {
        Font font = this.figure().getFont();
        font.dispose();
        this.figure().setFont(PlugIn.getFontPreference("font", false, false));
    }

    protected void updateColors(IFigure f) {
        f.setForegroundColor(PlugIn.getColorPreference("color.type.text"));
    }

    public void updateLabel() {
        this.repaintLabel(this.figure());
    }

    protected IIconHolder getNameLabel() {
        return this.figure();
    }

    protected JavadocGrabber getJavadocGrabber() {
        return new JavadocGrabber(){
            private boolean _alive = true;

            public boolean visit(FieldDeclaration node) {
                if (!this._alive) {
                    return false;
                }
                for (VariableDeclarationFragment vdf : (AbstractList)node.fragments()) {
                    if (!this.compareElements(vdf.resolveBinding().getJavaElement())) continue;
                    this._alive = false;
                    this._doc = FieldPart.this.getDoc(node.getJavadoc());
                    break;
                }
                return this._alive;
            }
        };
    }
}

