/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.cse.green.editor.model;

import edu.buffalo.cse.green.editor.DiagramEditor;
import edu.buffalo.cse.green.editor.controller.NotePart;
import edu.buffalo.cse.green.editor.controller.PropertyChange;
import edu.buffalo.cse.green.editor.model.AbstractModel;
import edu.buffalo.cse.green.editor.model.RootModel;
import edu.buffalo.cse.green.editor.model.commands.DeleteCommand;
import edu.buffalo.cse.green.editor.model.commands.DeleteNoteCommand;
import edu.buffalo.cse.green.xml.XMLConverter;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.jdt.core.IJavaElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NoteModel
extends AbstractModel<AbstractModel, RootModel, IJavaElement> {
    private String _label;

    public NoteModel() {
        this._label = "Double Click to Edit";
    }

    public NoteModel(String label) {
        this._label = label;
    }

    public void setLabel(String mesg) {
        String oldMesg = this._label;
        this._label = mesg;
        this.firePropertyChange(PropertyChange.Note, oldMesg, mesg);
    }

    public String getLabel() {
        return this._label;
    }

    @Override
    public void toXML(XMLConverter converter) {
        converter.pushHeader("note");
        converter.writeKey("text", this._label);
        converter.writeKey("height", "" + this.getSize().height);
        converter.writeKey("width", "" + this.getSize().width);
        converter.writeKey("x", "" + this.getLocation().x);
        converter.writeKey("y", "" + this.getLocation().y);
        super.toXML(converter);
        converter.popHeader();
    }

    @Override
    public int getContextMenuFlag() {
        return 8;
    }

    @Override
    public DeleteCommand getDeleteCommand(DiagramEditor editor) {
        return new DeleteNoteCommand(this);
    }

    public Command getHideCommand(DiagramEditor editor) {
        return null;
    }

    @Override
    public Class getPartClass() {
        return NotePart.class;
    }

    @Override
    public IJavaElement getJavaElement() {
        return null;
    }

    @Override
    public void removeFromParent() {
        ((RootModel)this.getParent()).removeChild(this);
    }

    @Override
    public String toString() {
        return this.getLabel();
    }

    @Override
    public void handleDispose() {
    }

    @Override
    public int invokeCreationDialog(ToolEntry tool) {
        return 0;
    }

    @Override
    public void createNewInstance(AbstractModel model) {
        if (model.getSize() == null || model.getSize().height < 5 || model.getSize().width < 5) {
            model.setSize(new Dimension(150, 50));
        }
        this.getRootModel().addChild((NoteModel)model);
    }
}

