/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.cse.green.editor.model.commands;

import edu.buffalo.cse.green.GreenException;
import edu.buffalo.cse.green.editor.DiagramEditor;
import edu.buffalo.cse.green.editor.model.RootModel;
import edu.buffalo.cse.green.editor.model.TypeModel;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.commands.Command;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

public class AddJavaElementCommand
extends Command {
    private DiagramEditor _editor;
    private IJavaElement _element;
    private List<Command> _commands;

    public AddJavaElementCommand(DiagramEditor editor, IJavaElement element) {
        this._editor = editor;
        this._element = element;
        this._commands = new ArrayList<Command>();
    }

    public void execute() {
        RootModel root = this._editor.getRootModel();
        try {
            if (this._element instanceof IJavaProject) {
                IJavaProject project = (IJavaProject)this._element;
                IPackageFragment[] iPackageFragmentArray = project.getPackageFragments();
                int n = 0;
                int n2 = iPackageFragmentArray.length;
                while (n < n2) {
                    IPackageFragment packFrag = iPackageFragmentArray[n];
                    if (!packFrag.isReadOnly()) {
                        this.openPackage(root, packFrag);
                    }
                    ++n;
                }
            } else if (this._element instanceof IPackageFragment) {
                IPackageFragment packFrag = (IPackageFragment)this._element;
                this.openPackage(root, packFrag);
            } else if (this._element instanceof ICompilationUnit) {
                this.openCU(root, (ICompilationUnit)this._element);
            } else if (this._element instanceof IClassFile) {
                this.openClass(root, (IClassFile)this._element);
            } else if (this._element instanceof IType) {
                this.createType(root, (IType)this._element);
            } else if (this._element instanceof IMember) {
                this._element = this._element.getAncestor(7);
                this.createType(root, (IType)this._element);
            } else {
                GreenException.illegalOperation("Cannot open this kind of Java Element: " + this._element);
            }
            this._editor.refresh();
            this._editor.checkDirty();
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
    }

    private void openPackage(RootModel model, IPackageFragment packFrag) throws JavaModelException {
        ICompilationUnit[] cus = packFrag.getCompilationUnits();
        IClassFile[] classFiles = packFrag.getClassFiles();
        ICompilationUnit[] iCompilationUnitArray = cus;
        int n = 0;
        int n2 = iCompilationUnitArray.length;
        while (n < n2) {
            ICompilationUnit cu = iCompilationUnitArray[n];
            this.openCU(model, cu);
            ++n;
        }
        iCompilationUnitArray = classFiles;
        n = 0;
        n2 = iCompilationUnitArray.length;
        while (n < n2) {
            ICompilationUnit classFile = iCompilationUnitArray[n];
            this.openClass(model, (IClassFile)classFile);
            ++n;
        }
    }

    private void openCU(RootModel root, ICompilationUnit cu) throws JavaModelException {
        IType[] types = cu.getAllTypes();
        int i = 0;
        while (i < types.length) {
            this.createType(root, types[i]);
            ++i;
        }
    }

    private void openClass(RootModel root, IClassFile classFile) {
        try {
            IType type = classFile.getType();
            this.createType(root, type);
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
    }

    public boolean canUndo() {
        return false;
    }

    private void createType(RootModel root, IType type) {
        AddTypeCommand command = new AddTypeCommand(root, type);
        this._commands.add(command);
        command.execute();
    }

    public void undo() {
        for (Command command : this._commands) {
            command.undo();
        }
        this._commands.clear();
    }

    public void redo() {
        this.execute();
    }

    class AddTypeCommand
    extends Command {
        private RootModel _root;
        private IType _type;
        private TypeModel _model;

        public AddTypeCommand(RootModel root, IType type) {
            this._root = root;
            this._type = type;
        }

        public void execute() {
            this._model = this._root.createTypeModel(this._type);
            if (this._model != null) {
                this._root.placeUMLBox(this._model);
            }
        }

        public void undo() {
            this._model.removeFromParent();
        }

        public void redo() {
            this.execute();
        }
    }
}

