/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.cse.green.editor.view;

import edu.buffalo.cse.green.editor.view.RelationshipFigure;
import org.eclipse.draw2d.Bendpoint;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;

public class GreenBendpoint
implements Bendpoint {
    private RelationshipFigure _rFigure;
    private Point _location = new Point(0, 0);
    private Point _oldSource;
    private Point _oldTarget;

    public GreenBendpoint(RelationshipFigure rFigure) {
        this.setConnection(rFigure);
    }

    protected RelationshipFigure getConnection() {
        return this._rFigure;
    }

    public void setAbsoluteLocation(int x, int y) {
        this.setAbsoluteLocation(new Point(x, y));
    }

    public void setAbsoluteLocation(Point p) {
        this._location = p;
    }

    public Point getAbsoluteLocation() {
        return this._location;
    }

    public Point getLocation() {
        if (this._rFigure.isRecursive()) {
            Point topRight = this._rFigure.getRecursiveAnchor().getBounds().getTopRight();
            return new Point(this._location.x + topRight.x, this._location.y + topRight.y);
        }
        if (this._oldSource == null) {
            this._oldSource = this.getSourceLocation();
            this._oldTarget = this.getTargetLocation();
            return this._location;
        }
        Dimension ds = this.getSourceLocation().getDifference(this._oldSource);
        Dimension dt = this.getTargetLocation().getDifference(this._oldTarget);
        this._oldSource = this.getSourceLocation();
        this._oldTarget = this.getTargetLocation();
        this._location = new Point(this._location.x + (ds.width + dt.width) / 2, this._location.y + (ds.height + dt.height) / 2);
        return this._location;
    }

    private void setConnection(RelationshipFigure rFigure) {
        this._rFigure = rFigure;
    }

    private Point getSourceLocation() {
        return this.getConnection().getSourceAnchor().getLocation(this.getConnection().getSourceAnchor().getReferencePoint());
    }

    private Point getTargetLocation() {
        return this.getConnection().getTargetAnchor().getLocation(this.getConnection().getTargetAnchor().getReferencePoint());
    }
}

