/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.cse.green;

import edu.buffalo.cse.green.GreenException;
import edu.buffalo.cse.green.JavaModelListener;
import edu.buffalo.cse.green.RelationshipSubtype;
import edu.buffalo.cse.green.designpattern.DesignPatternGroup;
import edu.buffalo.cse.green.editor.DiagramEditor;
import edu.buffalo.cse.green.editor.action.ContextAction;
import edu.buffalo.cse.green.editor.controller.FieldPart;
import edu.buffalo.cse.green.editor.controller.MethodPart;
import edu.buffalo.cse.green.editor.controller.NotePart;
import edu.buffalo.cse.green.editor.controller.TypePart;
import edu.buffalo.cse.green.editor.model.MemberModel;
import edu.buffalo.cse.green.editor.model.filters.MemberFilter;
import edu.buffalo.cse.green.editor.save.ISaveFormat;
import edu.buffalo.cse.green.relationships.RelationshipGenerator;
import edu.buffalo.cse.green.relationships.RelationshipGroup;
import edu.buffalo.cse.green.relationships.RelationshipRecognizer;
import edu.buffalo.cse.green.relationships.RelationshipRemover;
import edu.buffalo.cse.green.types.ITypeProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PlugIn
extends AbstractUIPlugin {
    private static PlugIn PLUGIN;
    private static ResourceBundle BUNDLE;
    private static List<DesignPatternGroup> _designPatterns;
    private static Map<Class, Class> _partToView;
    private static Map<Class, RelationshipGroup> _relationshipMap;
    private static List<ContextAction> _actions;
    public static final String GREEN_EXTENSION = "dia";
    private static final String resourceBundleId = "edu.buffalo.cse.green.PlugInPluginResources";
    private static final String DESIGN_PATTERN_MENU_NAME = "Design Patterns";
    private static final String CONTEXT_ACTION_ID = "edu.buffalo.cse.green.contextAction";
    private static final String DESIGN_PATTERN_ID = "edu.buffalo.cse.green.designPattern";
    private static final String RELATIONSHIP_ID = "edu.buffalo.cse.green.relationships";
    private static final String VIEW_ID = "edu.buffalo.cse.green.editorViews";
    private static final String SAVE_FORMAT_ID = "edu.buffalo.cse.green.saveFormat";
    private static final String JAVA_TYPE_ID = "edu.buffalo.cse.green.javaType";
    private static boolean _recognizersEnabled;
    private static boolean _isUserMode;
    private static Map<String, List<RelationshipSubtype>> _relationships;
    private static Map<String, ISaveFormat> SAVE_FORMAT_MAP;
    private static Map<String, ITypeProperties> _mTypeProperties;
    private static List<RelationshipGroup> _relationshipGroups;

    static {
        _designPatterns = new ArrayList<DesignPatternGroup>();
        _partToView = new HashMap<Class, Class>();
        _relationshipMap = new HashMap<Class, RelationshipGroup>();
        _actions = new ArrayList<ContextAction>();
        _recognizersEnabled = true;
        _isUserMode = true;
        SAVE_FORMAT_MAP = new HashMap<String, ISaveFormat>();
        _mTypeProperties = new HashMap<String, ITypeProperties>();
    }

    public PlugIn() {
        _relationships = new HashMap<String, List<RelationshipSubtype>>();
        _relationshipGroups = new ArrayList<RelationshipGroup>();
        PLUGIN = this;
        try {
            BUNDLE = ResourceBundle.getBundle(resourceBundleId);
        }
        catch (MissingResourceException missingResourceException) {
            BUNDLE = null;
        }
    }

    public static void setTestMode() {
        _isUserMode = false;
    }

    public static boolean isUserMode() {
        return _isUserMode;
    }

    public static IWorkbenchHelpSystem getWorkbenchHelp() {
        return PlugIn.getDefault().getWorkbench().getHelpSystem();
    }

    public static RelationshipGroup getRelationshipGroup(Class klass) {
        return _relationshipMap.get(klass);
    }

    private static void addRelationshipGroup(RelationshipGroup group) {
        _relationshipMap.put(group.getPartClass(), group);
        _relationshipGroups.add(group);
        List<RelationshipSubtype> rels = _relationships.get(group.getName());
        RelationshipSubtype relSubtype = new RelationshipSubtype(group, group.getSubtype());
        if (rels == null) {
            rels = new ArrayList<RelationshipSubtype>();
            rels.add(relSubtype);
            _relationships.put(group.getName(), rels);
        } else {
            rels.add(relSubtype);
        }
    }

    public static List<RelationshipSubtype> getRelationshipSubtypes(String name) {
        return _relationships.get(name);
    }

    public List<IConfigurationElement> getConfigElements(String extensionPointId) {
        IExtension[] extensionPoints;
        ArrayList<IConfigurationElement> configurationElements = new ArrayList<IConfigurationElement>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtension[] iExtensionArray = extensionPoints = registry.getExtensionPoint(extensionPointId).getExtensions();
        int n = 0;
        int n2 = iExtensionArray.length;
        while (n < n2) {
            IExtension extension = iExtensionArray[n];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = 0;
            int n4 = iConfigurationElementArray.length;
            while (n3 < n4) {
                IConfigurationElement element = iConfigurationElementArray[n3];
                configurationElements.add(element);
                ++n3;
            }
            ++n;
        }
        return configurationElements;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        try {
            for (IConfigurationElement element : this.getConfigElements(SAVE_FORMAT_ID)) {
                ISaveFormat format = (ISaveFormat)element.createExecutableExtension("class");
                if (SAVE_FORMAT_MAP.containsKey(format.getExtension())) {
                    GreenException.illegalOperation("Duplicate Green file extension detected. Check you plugin.xml files.");
                }
                String ext = format.getExtension();
                Pattern valid = Pattern.compile("[a-z0-9]+");
                Matcher matcher = valid.matcher(ext);
                if (!matcher.matches() || ext.length() > 4) {
                    GreenException.illegalOperation("Invalid extension. Valid extensions must consist of alphanumeric characters and must be between 1 and 4 characters in length.");
                }
                SAVE_FORMAT_MAP.put(ext, format);
            }
            for (IConfigurationElement element : this.getConfigElements(VIEW_ID)) {
                String memberFigure = element.getAttribute("memberClass");
                String noteFigure = element.getAttribute("noteClass");
                String typeFigure = element.getAttribute("typeClass");
                _partToView.put(FieldPart.class, Class.forName(memberFigure));
                _partToView.put(MethodPart.class, Class.forName(memberFigure));
                _partToView.put(NotePart.class, Class.forName(noteFigure));
                _partToView.put(TypePart.class, Class.forName(typeFigure));
            }
            for (IConfigurationElement element : this.getConfigElements(CONTEXT_ACTION_ID)) {
                Object action = element.createExecutableExtension("class");
                if (!(action instanceof ContextAction)) {
                    GreenException.illegalOperation("Action class must be a subclass of ContextAction");
                }
                ContextAction contextAction = (ContextAction)((Object)action);
                _actions.add(contextAction);
            }
            List<IConfigurationElement> elements = this.getConfigElements(RELATIONSHIP_ID);
            int x = 0;
            while (x < elements.size()) {
                RelationshipGenerator gen = (RelationshipGenerator)((Object)elements.get(x + 1).createExecutableExtension("class"));
                RelationshipRecognizer rec = (RelationshipRecognizer)((Object)elements.get(x + 2).createExecutableExtension("class"));
                RelationshipRemover rem = (RelationshipRemover)((Object)elements.get(x + 3).createExecutableExtension("class"));
                boolean classToClass = !elements.get(x + 4).getAttribute("classToClass").equals("");
                boolean classToEnum = !elements.get(x + 4).getAttribute("classToEnum").equals("");
                boolean classToInterface = !elements.get(x + 4).getAttribute("classToInterface").equals("");
                boolean enumToClass = !elements.get(x + 4).getAttribute("enumToClass").equals("");
                boolean enumToEnum = !elements.get(x + 4).getAttribute("enumToEnum").equals("");
                boolean enumToInterface = !elements.get(x + 4).getAttribute("enumToInterface").equals("");
                boolean interfaceToClass = !elements.get(x + 4).getAttribute("interfaceToClass").equals("");
                boolean interfaceToEnum = !elements.get(x + 4).getAttribute("interfaceToEnum").equals("");
                boolean interfaceToInterface = !elements.get(x + 4).getAttribute("interfaceToInterface").equals("");
                IConfigurationElement dec = elements.get(x);
                RelationshipGroup rGroup = new RelationshipGroup(dec.getDeclaringExtension().getLabel(), dec.getAttribute("label"), dec.createExecutableExtension("class").getClass(), gen, rec, rem, classToClass, classToEnum, classToInterface, enumToClass, enumToEnum, enumToInterface, interfaceToClass, interfaceToEnum, interfaceToInterface);
                PlugIn.addRelationshipGroup(rGroup);
                x += 5;
            }
            for (IConfigurationElement element : this.getConfigElements(DESIGN_PATTERN_ID)) {
                Object designPattern = element.createExecutableExtension("class");
                if (!(designPattern instanceof DesignPatternGroup)) continue;
                _designPatterns.add((DesignPatternGroup)designPattern);
            }
            for (IConfigurationElement element : this.getConfigElements(JAVA_TYPE_ID)) {
                Object javaType = element.createExecutableExtension("class");
                if (javaType instanceof ITypeProperties) {
                    ITypeProperties prop = (ITypeProperties)javaType;
                    _mTypeProperties.put(prop.getLabel(), prop);
                    continue;
                }
                GreenException.illegalExtensionClass(javaType.getClass(), ITypeProperties.class);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JavaCore.addElementChangedListener((IElementChangedListener)JavaModelListener.getListener());
    }

    public static Collection<ITypeProperties> getAvailableTypes() {
        return _mTypeProperties.values();
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
    }

    public static PlugIn getDefault() {
        return PLUGIN;
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = PlugIn.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        return BUNDLE;
    }

    public static IProgressMonitor getEmptyProgressMonitor() {
        return new NullProgressMonitor();
    }

    public static String getRelationshipName(Class klass) {
        return _relationshipMap.get(klass).getName();
    }

    public static List<Class> getRelationships() {
        return new ArrayList<Class>((Collection)_relationshipMap.keySet());
    }

    public static List<ContextAction> getActions() {
        return _actions;
    }

    public static Shell getDefaultShell() {
        return PlugIn.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
    }

    public static void addDesignPatternMenu(DiagramEditor editor, IMenuManager manager) {
        MenuManager designPatternMM = new MenuManager(DESIGN_PATTERN_MENU_NAME, null);
        for (DesignPatternGroup group : _designPatterns) {
            ContextAction cAction = group.getAction();
            cAction.setSelectionProvider(editor);
            cAction.setContents();
            designPatternMM.add((IAction)cAction);
        }
        manager.add((IContributionItem)designPatternMM);
    }

    public static boolean isRecognizersEnabled() {
        return _recognizersEnabled;
    }

    public static void runWithoutRecognizers(Runnable runnable) {
        try {
            _recognizersEnabled = false;
            runnable.run();
        }
        finally {
            _recognizersEnabled = true;
        }
    }

    public static String getSubMenuLabel(String menuGroup) {
        String menuLabel = menuGroup.substring(menuGroup.lastIndexOf(46) + 1).toLowerCase();
        return String.valueOf(menuLabel.substring(0, 1).toUpperCase()) + menuLabel.substring(1);
    }

    public static IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public static int getVersion() {
        String version = (String)PlugIn.getDefault().getBundle().getHeaders().get("Bundle-Version");
        int firstDot = version.indexOf(46);
        int lastDot = version.lastIndexOf(46);
        int major = Integer.parseInt(version.substring(0, firstDot));
        int minor = Integer.parseInt(version.substring(firstDot + 1, lastDot));
        int revision = Integer.parseInt(version.substring(lastDot + 1));
        return major * 10000 + minor * 100 + revision;
    }

    public static Class getViewPart(Class<?> klass) {
        return _partToView.get(klass);
    }

    private static IPreferenceStore getPreferences() {
        return PlugIn.getDefault().getPreferenceStore();
    }

    public static boolean getBooleanPreference(String key) {
        return PlugIn.getPreferences().getBoolean(key);
    }

    public static String getPreference(String key) {
        return PlugIn.getPreferences().getString(key);
    }

    public static Font getFontPreference(String key, boolean bold, boolean italic) {
        int style = (bold ? 1 : 0) + (italic ? 2 : 0);
        StringTokenizer tokens = new StringTokenizer("0" + PlugIn.getPreference(key), "|");
        tokens.nextToken();
        String fontName = tokens.nextToken();
        int fontSize = Integer.parseInt(tokens.nextToken());
        return new Font(null, fontName, fontSize, style);
    }

    public static Color getColorPreference(String key) {
        String col = PlugIn.getPreference(key);
        int comma1 = col.indexOf(44);
        int comma2 = col.lastIndexOf(44);
        int r = Integer.parseInt(col.substring(0, comma1));
        int g = Integer.parseInt(col.substring(comma1 + 1, comma2));
        int b = Integer.parseInt(col.substring(comma2 + 1));
        return new Color(null, r, g, b);
    }

    public static int getIntegerPreference(String key) {
        return PlugIn.getPreferences().getInt(key);
    }

    public static ISaveFormat getSaveFormat(String extension) {
        return SAVE_FORMAT_MAP.get(extension);
    }

    public static List<String> getSaveFormats() {
        HashSet formats = new HashSet(SAVE_FORMAT_MAP.keySet());
        ArrayList<String> orderedFormats = new ArrayList<String>();
        formats.remove(GREEN_EXTENSION);
        orderedFormats.add(GREEN_EXTENSION);
        while (formats.size() > 0) {
            String last = "{";
            for (String string : formats) {
                if (string.compareTo(last) >= 0) continue;
                last = string;
            }
            formats.remove(last);
            orderedFormats.add(last);
        }
        return orderedFormats;
    }

    public static List<RelationshipGroup> getRelationshipGroups() {
        ArrayList<RelationshipGroup> groups = new ArrayList<RelationshipGroup>();
        groups.addAll(_relationshipMap.values());
        return groups;
    }

    public static boolean filterMember(MemberModel model) {
        if (model == null) {
            return false;
        }
        for (MemberFilter filter : PlugIn.getMemberFilters()) {
            if (!filter.isFiltered((IMember)model.getMember())) continue;
            return true;
        }
        return false;
    }

    public static List<MemberFilter> getMemberFilters() {
        ArrayList<MemberFilter> filters = new ArrayList<MemberFilter>();
        try {
            StringTokenizer tokens = new StringTokenizer(PlugIn.getPreference("filters.member"), "|");
            while (tokens.hasMoreTokens()) {
                String token = tokens.nextToken();
                filters.add(new MemberFilter(token));
            }
        }
        catch (Exception exception) {
            GreenException.warn("problem loading filters");
        }
        return filters;
    }

    public static List<RelationshipGroup> getRelationshipList() {
        return _relationshipGroups;
    }

    public static Map<String, ITypeProperties> getTypeProperties() {
        return _mTypeProperties;
    }
}

