/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.cse.green.dialogs;

import edu.buffalo.cse.green.GreenException;
import edu.buffalo.cse.green.dialogs.MethodDialogListener;
import edu.buffalo.cse.green.editor.model.MethodModel;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class ChooseMethodsDialog
extends Dialog {
    private IType _type;
    private List<MethodDialogListener> _listeners = new ArrayList<MethodDialogListener>();

    public ChooseMethodsDialog(Shell shell, IType type) {
        super(shell);
        shell.setText("Choose Methods");
        this._type = type;
    }

    public void addMethodDialogListener(MethodDialogListener listener) {
        this._listeners.add(listener);
    }

    public boolean removeMethodDialogListener(MethodDialogListener listener) {
        return this._listeners.remove(listener);
    }

    protected Control createContents(Composite parent) {
        try {
            if (this._type.getMethods().length == 0) {
                for (MethodDialogListener listener : this._listeners) {
                    listener.okPressed(new ArrayList<IMethod>());
                    GreenException.errorDialog("No methods exist in the given source class");
                }
            }
            GridLayout grid = new GridLayout(1, true);
            parent.setLayout((Layout)grid);
            Label label = new Label(parent, 0);
            label.setText("Select methods to create the relationship in:");
            final Table displayedMethods = new Table(parent, 32);
            JavaElementLabelProvider icon = new JavaElementLabelProvider();
            IMethod[] iMethodArray = this._type.getMethods();
            int n = 0;
            int n2 = iMethodArray.length;
            while (n < n2) {
                IMethod method = iMethodArray[n];
                TableItem methodItem = new TableItem(displayedMethods, 32);
                methodItem.setText(MethodModel.getMethodSignature(method));
                methodItem.setImage(icon.getImage((Object)method));
                methodItem.setData((Object)method);
                ++n;
            }
            Composite buttonHolder = new Composite(parent, 0);
            buttonHolder.setLayout((Layout)new GridLayout(2, true));
            buttonHolder.setLayoutData((Object)new GridData(131));
            Button okButton = new Button(buttonHolder, 0);
            okButton.setText("OK");
            okButton.setLayoutData((Object)new GridData(768));
            okButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    ArrayList<IMethod> selectedMethods = new ArrayList<IMethod>();
                    TableItem[] tableItemArray = displayedMethods.getItems();
                    int n = 0;
                    int n2 = tableItemArray.length;
                    while (n < n2) {
                        TableItem item = tableItemArray[n];
                        if (item.getChecked()) {
                            selectedMethods.add((IMethod)item.getData());
                        }
                        ++n;
                    }
                    for (MethodDialogListener listener : ChooseMethodsDialog.this._listeners) {
                        listener.okPressed(selectedMethods);
                    }
                    ChooseMethodsDialog.this.getShell().dispose();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            Button cancelButton = new Button(buttonHolder, 0);
            cancelButton.setText("Cancel");
            cancelButton.setLayoutData((Object)new GridData(768));
            cancelButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    ChooseMethodsDialog.this.getShell().dispose();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            return parent;
        }
        catch (JavaModelException e) {
            e.printStackTrace();
            return null;
        }
    }
}

