/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.cse.green.dialogs;

import edu.buffalo.cse.green.GreenException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;

public abstract class GreenWizard
extends Wizard {
    public static final String ERROR_TITLE = "Error";
    private boolean _cancelled = false;

    public final boolean performFinish() {
        if (this._cancelled) {
            return true;
        }
        try {
            return this.doFinish();
        }
        catch (GreenException e) {
            this.handleFinishException(e);
            return false;
        }
    }

    public boolean performCancel() {
        this._cancelled = true;
        return super.performCancel();
    }

    protected void handleFinishException(Exception e) {
        if (e instanceof InvocationTargetException) {
            InvocationTargetException ie = (InvocationTargetException)e;
            e = (Exception)ie.getCause();
        }
        MessageDialog.openError((Shell)this.getShell(), (String)ERROR_TITLE, (String)e.getMessage());
    }

    protected abstract boolean doFinish();
}

