/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.cse.green.dialogs;

import edu.buffalo.cse.green.PlugIn;
import edu.buffalo.cse.green.dialogs.ChooseTypeDialog;
import edu.buffalo.cse.green.dialogs.IVisibilityChangedListener;
import edu.buffalo.cse.green.dialogs.NewElementWizardSettings;
import edu.buffalo.cse.green.dialogs.VisibilityComposite;
import edu.buffalo.cse.green.editor.model.filters.MemberVisibility;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.ui.wizards.NewElementWizardPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class NewMemberSignatureWizardPage
extends NewElementWizardPage {
    private VisibilityComposite _visibility;
    private Button _checkboxAbstract;
    private Button _checkboxFinal;
    private Button _checkboxStatic;
    private Button _typeByte;
    private Button _typeShort;
    private Button _typeInt;
    private Button _typeLong;
    private Button _typeFloat;
    private Button _typeDouble;
    private Button _typeBoolean;
    private Button _typeChar;
    private Button _typeVoid;
    private Button _browseTypeButton;
    private Text _name;
    private boolean _isInterface;
    private Text _typeNameText;

    public NewMemberSignatureWizardPage(String name) {
        super(name);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite group = new Composite(parent, 0);
        int columns = 4;
        GridLayout layout = new GridLayout();
        layout.numColumns = columns;
        group.setLayout((Layout)layout);
        this.createNameControls(group, columns);
        this.createModifierControls(group, columns);
        this.populateTypeGroup(group, columns);
        this.setControl((Control)group);
        Dialog.applyDialogFont((Control)group);
        PlugIn.getWorkbenchHelp().setHelp((Control)group, "org.eclipse.jdt.ui.new_class_wizard_page_context");
        this._typeNameText.setText("String");
        if (this.allowVoidType()) {
            this._typeVoid.setSelection(true);
        }
    }

    public String getTypeName() {
        if (this._typeBoolean.getSelection()) {
            return "boolean";
        }
        if (this._typeByte.getSelection()) {
            return "byte";
        }
        if (this._typeChar.getSelection()) {
            return "char";
        }
        if (this._typeDouble.getSelection()) {
            return "double";
        }
        if (this._typeFloat.getSelection()) {
            return "float";
        }
        if (this._typeInt.getSelection()) {
            return "int";
        }
        if (this._typeLong.getSelection()) {
            return "long";
        }
        if (this._typeShort.getSelection()) {
            return "short";
        }
        if (this.allowVoidType() && this._typeVoid.getSelection()) {
            return "void";
        }
        String typeName = this._typeNameText.getText();
        if (typeName.startsWith("java.lang.")) {
            return typeName.substring(typeName.lastIndexOf(".") + 1);
        }
        return this._typeNameText.getText();
    }

    public List<String> getModifiers() {
        ArrayList<String> flags = new ArrayList<String>();
        String visibility = this._visibility.getValue().getCodeText();
        if (this._checkboxAbstract != null && this._checkboxAbstract.getSelection()) {
            flags.add("abstract");
        }
        if (this._checkboxFinal != null && this._checkboxFinal.getSelection()) {
            flags.add("final");
        }
        if (this._checkboxStatic != null && this._checkboxStatic.getSelection()) {
            flags.add("static");
        }
        if (visibility != null) {
            flags.add(0, visibility);
        }
        return flags;
    }

    private void populateTypeGroup(Composite parent, int columns) {
        Label typeLabel = new Label(parent, 32);
        typeLabel.setText("&Return Type:");
        typeLabel.setLayoutData((Object)new GridData());
        Composite typeSubGroup = new Composite(parent, 32);
        GridData data = new GridData(256);
        data.horizontalSpan = columns - 2;
        typeSubGroup.setLayoutData((Object)data);
        int subGroupColumns = 5;
        typeSubGroup.setLayout((Layout)new GridLayout(subGroupColumns, true));
        if (this.allowVoidType()) {
            this._typeVoid = new Button(typeSubGroup, 16);
            this._typeVoid.setText("void");
            this._typeVoid.setLayoutData((Object)new GridData());
        }
        this._typeByte = new Button(typeSubGroup, 16);
        this._typeShort = new Button(typeSubGroup, 16);
        this._typeInt = new Button(typeSubGroup, 16);
        this._typeLong = new Button(typeSubGroup, 16);
        this._typeFloat = new Button(typeSubGroup, 16);
        this._typeDouble = new Button(typeSubGroup, 16);
        this._typeBoolean = new Button(typeSubGroup, 16);
        this._typeChar = new Button(typeSubGroup, 16);
        this._typeByte.setText("byte");
        this._typeByte.setLayoutData((Object)new GridData());
        this._typeShort.setText("short");
        this._typeShort.setLayoutData((Object)new GridData());
        this._typeInt.setText("int");
        this._typeInt.setLayoutData((Object)new GridData());
        this._typeLong.setText("&long");
        this._typeLong.setLayoutData((Object)new GridData());
        this._typeFloat.setText("float");
        this._typeFloat.setLayoutData((Object)new GridData());
        this._typeDouble.setText("double");
        this._typeDouble.setLayoutData((Object)new GridData());
        this._typeBoolean.setText("boolean");
        this._typeBoolean.setLayoutData((Object)new GridData());
        this._typeChar.setText("char");
        this._typeChar.setLayoutData((Object)new GridData());
        this._typeNameText = new Text(parent, 18692);
        data = new GridData(256);
        data.horizontalSpan = columns - 1;
        this._typeNameText.setLayoutData((Object)data);
        this._typeNameText.setText("Object");
        this._typeNameText.setEnabled(false);
        this._browseTypeButton = new Button(parent, 0x1000008);
        this._browseTypeButton.setText("&Browse ...");
        this._browseTypeButton.setLayoutData((Object)new GridData());
        this._browseTypeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                List<IType> types = new ChooseTypeDialog(false).open();
                if (!types.isEmpty()) {
                    String selectedName = types.get(0).getFullyQualifiedName();
                    NewMemberSignatureWizardPage.this._typeNameText.setText(selectedName);
                    NewMemberSignatureWizardPage.this._typeBoolean.setSelection(false);
                    NewMemberSignatureWizardPage.this._typeByte.setSelection(false);
                    NewMemberSignatureWizardPage.this._typeChar.setSelection(false);
                    NewMemberSignatureWizardPage.this._typeDouble.setSelection(false);
                    NewMemberSignatureWizardPage.this._typeFloat.setSelection(false);
                    NewMemberSignatureWizardPage.this._typeInt.setSelection(false);
                    NewMemberSignatureWizardPage.this._typeLong.setSelection(false);
                    NewMemberSignatureWizardPage.this._typeShort.setSelection(false);
                    if (NewMemberSignatureWizardPage.this.allowVoidType()) {
                        NewMemberSignatureWizardPage.this._typeVoid.setSelection(false);
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void createModifierControls(Composite parent, int columns) {
        final NewElementWizardSettings settings = this.getSettings();
        Label modifiersLabel = new Label(parent, 16416);
        modifiersLabel.setText("&Modifiers:");
        modifiersLabel.setLayoutData((Object)new GridData());
        this._visibility = new VisibilityComposite(parent, 0, false);
        this._visibility.addListener(new IVisibilityChangedListener(){

            public void visibilityChanged(MemberVisibility value) {
                if (value.equals((Object)MemberVisibility.PRIVATE) && settings.isAbstractAvailable()) {
                    NewMemberSignatureWizardPage.this._checkboxAbstract.setSelection(false);
                }
            }
        });
        GridData data = new GridData();
        data.horizontalSpan = 3;
        this._visibility.setLayoutData(data);
        if (settings.isAbstractAvailable()) {
            this._checkboxAbstract = new Button((Composite)this._visibility, 32);
            this._checkboxAbstract.setText("abstract");
            this._checkboxAbstract.setEnabled(settings.isAbstractEnabled());
            this._checkboxAbstract.setSelection(settings.isAbstractSelected());
            this._checkboxAbstract.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    if (settings.isFinalAvailable()) {
                        NewMemberSignatureWizardPage.this._checkboxFinal.setSelection(false);
                        if (NewMemberSignatureWizardPage.this.getVisibilityContainer().getValue().equals((Object)MemberVisibility.PRIVATE)) {
                            NewMemberSignatureWizardPage.this.getVisibilityContainer().setPrivateSelected(false);
                            NewMemberSignatureWizardPage.this.getVisibilityContainer().setProtectedSelected(true);
                        }
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
        if (settings.isFinalAvailable()) {
            this._checkboxFinal = new Button((Composite)this._visibility, 32);
            this._checkboxFinal.setText("final");
            this._checkboxFinal.setEnabled(settings.isFinalEnabled());
            this._checkboxFinal.setSelection(settings.isFinalSelected());
            this._checkboxFinal.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    if (settings.isAbstractAvailable()) {
                        NewMemberSignatureWizardPage.this._checkboxAbstract.setSelection(false);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
        if (settings.isStaticAvailable()) {
            this._checkboxStatic = new Button((Composite)this._visibility, 32);
            this._checkboxStatic.setText("static");
            this._checkboxStatic.setEnabled(settings.isStaticEnabled());
            this._checkboxStatic.setSelection(settings.isStaticSelected());
        }
    }

    protected VisibilityComposite getVisibilityContainer() {
        return this._visibility;
    }

    private void createNameControls(Composite composite, int columns) {
        Label nameLabel = new Label(composite, 16672);
        nameLabel.setText("&Name");
        GridData data = new GridData();
        nameLabel.setLayoutData((Object)data);
        this._name = new Text(composite, 18692);
        data = new GridData(256);
        data.horizontalSpan = columns - 1;
        this._name.setLayoutData((Object)data);
        NewMemberSignatureWizardPage page = this;
        this._name.addKeyListener(new KeyListener((WizardPage)page){
            private final /* synthetic */ WizardPage val$page;
            {
                this.val$page = wizardPage;
            }

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                Pattern p = Pattern.compile("[_abcdefghijklmnopqrstuvwxyz]\\w*");
                Matcher m = p.matcher(NewMemberSignatureWizardPage.this._name.getText());
                if (!m.matches()) {
                    this.val$page.setErrorMessage("Invalid name");
                } else {
                    this.val$page.setErrorMessage(null);
                }
            }
        });
        page.setErrorMessage("Invalid name");
    }

    public String getName() {
        return this._name.getText();
    }

    protected void setInterface(boolean isInterface) {
        this._isInterface = isInterface;
    }

    protected abstract NewElementWizardSettings getSettings();

    protected abstract boolean allowVoidType();

    protected boolean isInterface() {
        return this._isInterface;
    }
}

