/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.cse.green.dialogs;

import edu.buffalo.cse.green.PlugIn;
import edu.buffalo.cse.green.dialogs.NewElementWizard;
import edu.buffalo.cse.green.dialogs.NewElementWizardSettings;
import edu.buffalo.cse.green.dialogs.NewMemberSignatureWizardPage;
import edu.buffalo.cse.green.editor.model.TypeModel;
import java.util.List;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;

public class NewMethodWizard
extends NewElementWizard {
    private NewMethodWizardPage _page;
    private String _methodName;
    private TypeModel _parent;
    private List<String> _modifiers;
    private String _returnTypeName;

    public NewMethodWizard(TypeModel parent) {
        this._parent = parent;
        this._methodName = "";
        this._returnTypeName = "";
        this.setDialogSettings(PlugIn.getDefault().getDialogSettings());
        this.setWindowTitle("Add Method");
    }

    public void addPages() {
        super.addPages();
        this._page = new NewMethodWizardPage(this._parent.getType().getJavaProject());
        try {
            this._page.setInterface(this._parent.isInterface());
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        this.addPage((IWizardPage)this._page);
    }

    public boolean doFinish() {
        boolean result = super.doFinish();
        if (this._page.getErrorMessage() != null) {
            result = false;
        }
        if (result) {
            this._methodName = this._page.getName();
            this._modifiers = this._page.getModifiers();
            this._returnTypeName = this._page.getTypeName();
        }
        return result;
    }

    public String getMethodName() {
        return this._methodName;
    }

    public String getModifiers() {
        String modifiers = this._modifiers.toString();
        modifiers = modifiers.replaceAll(",", "");
        return modifiers.substring(1, modifiers.length() - 1);
    }

    public String getReturnTypeName() {
        return this._returnTypeName;
    }

    protected boolean canRunForked() {
        return true;
    }

    class NewMethodWizardPage
    extends NewMemberSignatureWizardPage {
        public NewMethodWizardPage(IJavaProject project) {
            super("NewMethodWizardPage");
            this.setTitle("Add Method");
            this.setDescription("Create a new Java method.");
        }

        public void createControl(Composite parent) {
            super.createControl(parent);
            if (this.isInterface()) {
                this.getVisibilityContainer().setDefaultSelected(true);
                this.getVisibilityContainer().setPrivateEnabled(false);
                this.getVisibilityContainer().setProtectedEnabled(false);
                this.getVisibilityContainer().setPublicEnabled(false);
            } else {
                this.getVisibilityContainer().setPublicSelected(true);
            }
        }

        protected NewElementWizardSettings getSettings() {
            return this.isInterface() ? NewElementWizardSettings.InterfaceMethodSettings : NewElementWizardSettings.ClassMethodSettings;
        }

        protected boolean allowVoidType() {
            return true;
        }
    }
}

