/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.cse.green.editor;

import edu.buffalo.cse.green.GreenException;
import edu.buffalo.cse.green.PlugIn;
import edu.buffalo.cse.green.RelationshipSubtype;
import edu.buffalo.cse.green.editor.BendpointInformation;
import edu.buffalo.cse.green.editor.CompilationUnitMap;
import edu.buffalo.cse.green.editor.Context;
import edu.buffalo.cse.green.editor.DiagramEditorFilePolicies;
import edu.buffalo.cse.green.editor.DiagramPaletteFactory;
import edu.buffalo.cse.green.editor.DiagramPartFactory;
import edu.buffalo.cse.green.editor.Filter;
import edu.buffalo.cse.green.editor.GreenEditorInput;
import edu.buffalo.cse.green.editor.OutlinePage;
import edu.buffalo.cse.green.editor.action.AlterRelationshipVisibilityAction;
import edu.buffalo.cse.green.editor.action.ContextAction;
import edu.buffalo.cse.green.editor.action.Submenu;
import edu.buffalo.cse.green.editor.controller.AbstractPart;
import edu.buffalo.cse.green.editor.controller.RootPart;
import edu.buffalo.cse.green.editor.model.AbstractModel;
import edu.buffalo.cse.green.editor.model.MemberModel;
import edu.buffalo.cse.green.editor.model.RelationshipModel;
import edu.buffalo.cse.green.editor.model.RootModel;
import edu.buffalo.cse.green.editor.model.commands.CreateBendpointCommand;
import edu.buffalo.cse.green.editor.view.RelationshipFigure;
import edu.buffalo.cse.green.relationships.RelationshipRecognizer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Path;
import org.eclipse.draw2d.BendpointConnectionRouter;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.ManhattanConnectionRouter;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.KeyStroke;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStackListener;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.palette.PaletteListener;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.requests.BendpointRequest;
import org.eclipse.gef.requests.SimpleFactory;
import org.eclipse.gef.tools.CreationTool;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.gef.ui.parts.GraphicalEditorWithPalette;
import org.eclipse.gef.ui.parts.GraphicalViewerKeyHandler;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.editors.text.JavaFileEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiagramEditor
extends GraphicalEditorWithPalette
implements CommandStackListener,
ISelectionProvider {
    private boolean _ignoreMenuSelection = false;
    private static final String UML_CONTEXT_MENU_ID = "#PopupMenu";
    private static List<DiagramEditor> _editors = new ArrayList<DiagramEditor>();
    private static ListenerList _selectionChangedListeners = new ListenerList();
    private IStructuredSelection _selection = StructuredSelection.EMPTY;
    private KeyHandler _sharedKeyHandler;
    private static DiagramEditor ACTIVE_EDITOR;
    private RootModel _root;
    private IMenuManager _menuManager;
    private Context _context;
    private Set<RelationshipModel> _relationshipChanges;
    private List<BendpointInformation> _bendpoints;
    private CompilationUnitMap _cuMap;
    private MenuManager _contextMenu;
    private List<Filter> _filters;
    private static ConnectionRouter CONNECTION_ROUTER;
    private static OutlinePage _outlinePage;

    public DiagramEditor() {
        this.updateConnectionRouter();
        _editors.add(this);
        this._bendpoints = new ArrayList<BendpointInformation>();
        this.setEditDomain(new DefaultEditDomain((IEditorPart)this));
        this.getCommandStack().addCommandStackListener((CommandStackListener)this);
        this.getCommandStack().setUndoLimit(100);
        this._root = new RootModel();
        this._cuMap = new CompilationUnitMap();
        this._filters = new ArrayList<Filter>();
    }

    public Object getAdapter(Class adapter) {
        if (IContentOutlinePage.class.equals((Object)adapter)) {
            return OutlinePage.getInstance();
        }
        return super.getAdapter(adapter);
    }

    private void updateConnectionRouter() {
        CONNECTION_ROUTER = PlugIn.getBooleanPreference("manhattan.routing") ? new ManhattanConnectionRouter() : new BendpointConnectionRouter();
    }

    public static ToolEntry getSelectionTool() {
        return DiagramPaletteFactory.getSelectionTool();
    }

    /*
     * WARNING - void declaration
     */
    private void buildMenu(IMenuManager menuManager) {
        HashMap<String, MenuManager> menus = new HashMap<String, MenuManager>();
        HashMap<MenuManager, ArrayList<ContextAction>> mActions = new HashMap<MenuManager, ArrayList<ContextAction>>();
        MenuManager inv = new MenuManager("inv");
        inv.setVisible(false);
        menus.put(Submenu.Invisible.toString(), inv);
        ArrayList<Object> actions = new ArrayList<Object>();
        actions.addAll(PlugIn.getActions());
        for (Class partClass : PlugIn.getRelationships()) {
            AlterRelationshipVisibilityAction action = new AlterRelationshipVisibilityAction(partClass);
            actions.add((Object)action);
        }
        ArrayList<ContextAction> lastItems = new ArrayList<ContextAction>();
        for (ContextAction contextAction : actions) {
            MenuManager submenu = (MenuManager)menus.get((Object)contextAction.getPath());
            contextAction.calculateEnabled();
            contextAction.setSelectionProvider(this);
            contextAction.setText(contextAction.getLabel());
            if (submenu != null) continue;
            submenu = this.createMenuGroup(menus, contextAction.getPath());
            if (submenu == null) {
                lastItems.add(contextAction);
                continue;
            }
            List<ContextAction> actionList = (List)mActions.get(submenu);
            if (actionList == null) {
                actionList = new ArrayList<ContextAction>();
                mActions.put(submenu, (ArrayList<ContextAction>)actionList);
            }
            actionList.add(contextAction);
        }
        while (mActions.keySet().size() > 0) {
            String string = "zzz";
            MenuManager addMenu = null;
            for (MenuManager menu : mActions.keySet()) {
                void var7_11;
                if (menu.getMenuText().compareTo((String)var7_11) >= 0) continue;
                String string2 = menu.getMenuText();
                addMenu = menu;
            }
            this._contextMenu.add(addMenu);
            List actionList = (List)mActions.get(addMenu);
            mActions.remove(addMenu);
            while (actionList.size() > 0) {
                String string3 = "zzz";
                ContextAction addAction = null;
                for (ContextAction cAction : actionList) {
                    void var7_15;
                    if (cAction.getLabel().compareTo((String)var7_15) >= 0) continue;
                    String string4 = cAction.getLabel();
                    addAction = cAction;
                }
                addMenu.add(addAction);
                actionList.remove((Object)addAction);
            }
        }
        while (lastItems.size() > 0) {
            String string = "zzz";
            ContextAction addAction = null;
            for (ContextAction cAction : lastItems) {
                void var7_19;
                if (cAction.getLabel().compareTo((String)var7_19) >= 0) continue;
                String string5 = cAction.getLabel();
                addAction = cAction;
            }
            this._contextMenu.add(addAction);
            lastItems.remove((Object)addAction);
        }
        IJavaElement iJavaElement = this.getContext().getElement();
        if (iJavaElement instanceof IMember) {
            MemberModel model = (MemberModel)this.getRootModel().getModelFromElement(iJavaElement);
            model.appendQuickFixActionsToMenu(this._contextMenu);
        }
    }

    private MenuManager createMenuGroup(Map<String, MenuManager> menus, Submenu path) {
        StringTokenizer tokens = new StringTokenizer(path.toString(), "/");
        if (!tokens.hasMoreTokens()) {
            return null;
        }
        String menuName = tokens.nextToken();
        MenuManager menu = this.createMenuGroupHelper(menus, menuName);
        while (tokens.hasMoreTokens()) {
            menuName = String.valueOf(menuName) + "/" + tokens.nextToken();
            MenuManager submenu = this.createMenuGroupHelper(menus, menuName);
            menu.add((IContributionItem)submenu);
            menu = submenu;
        }
        return menu;
    }

    private MenuManager createMenuGroupHelper(Map<String, MenuManager> menus, String menuName) {
        MenuManager menu = menus.get(menuName);
        if (menu == null) {
            menu = new MenuManager(menuName.substring(menuName.lastIndexOf("/") + 1));
            menus.put(menuName, menu);
        }
        return menu;
    }

    private void updateMenuDisplay(IMenuManager menu) {
        AbstractModel selectedModel = this._context.getModel();
        IContributionItem[] iContributionItemArray = menu.getItems();
        int n = 0;
        int n2 = iContributionItemArray.length;
        while (n < n2) {
            IContributionItem item = iContributionItemArray[n];
            if (item instanceof IMenuManager) {
                this.updateMenuDisplay((IMenuManager)item);
            } else if (item instanceof ActionContributionItem) {
                ActionContributionItem aItem = (ActionContributionItem)item;
                ContextAction action = (ContextAction)aItem.getAction();
                aItem.setVisible(action.isVisible(selectedModel));
            }
            ++n;
        }
    }

    public static DiagramEditor findProjectEditor(IJavaProject project) {
        int x = 0;
        while (x < _editors.size()) {
            DiagramEditor editor = _editors.get(x);
            IJavaProject editorProject = editor.getProject();
            if (editorProject != null && project.getHandleIdentifier().equals(editorProject.getHandleIdentifier())) {
                return editor;
            }
            ++x;
        }
        return null;
    }

    public IJavaProject getProject() {
        return this.getRootModel().getProject();
    }

    public void dispose() {
        try {
            this.markAsSaved();
        }
        catch (Throwable throwable) {}
        _editors.remove((Object)this);
        this.getRootModel().dispose();
        if (ACTIVE_EDITOR == this) {
            ACTIVE_EDITOR = null;
        }
        super.dispose();
    }

    public void addBendpoint(RelationshipModel rModel, Point location) {
        this._bendpoints.add(new BendpointInformation(rModel, location));
    }

    public void doSave(IProgressMonitor iMonitor) {
        DiagramEditorFilePolicies.save(this, false);
    }

    public void doSaveAs() {
        DiagramEditorFilePolicies.save(this, true);
    }

    public void init(IEditorSite iSite, IEditorInput iInput) throws PartInitException {
        super.init(iSite, iInput);
        if (iInput instanceof JavaFileEditorInput) {
            JavaFileEditorInput jInput = (JavaFileEditorInput)iInput;
            this.setEditorInput(new GreenEditorInput(jInput.getPath().toFile()));
        }
        this.setPartName(this.getEditorInput().getName());
        IActionBars bars = this.getEditorSite().getActionBars();
        IContributionItem[] iContributionItemArray = bars.getToolBarManager().getItems();
        int n = 0;
        int n2 = iContributionItemArray.length;
        while (n < n2) {
            IContributionItem item = iContributionItemArray[n];
            if (item instanceof ActionContributionItem) {
                ActionContributionItem aItem = (ActionContributionItem)item;
                ContextAction action = (ContextAction)aItem.getAction();
                bars.setGlobalActionHandler(action.getGlobalActionHandler().getId(), (IAction)action);
            }
            ++n;
        }
        bars.updateActionBars();
    }

    protected void initializeGraphicalViewer() {
        this.getGraphicalViewer().setContents((Object)this.getRootModel());
        this.getRootPart().setEditor(this);
        IPathEditorInput input = (IPathEditorInput)this.getEditorInput();
        DiagramEditorFilePolicies.load(this, new File(input.getPath().toOSString()));
        this.createContextMenu();
        for (BendpointInformation bendpoint : this._bendpoints) {
            BendpointRequest request = bendpoint.getBendpointRequest(this);
            if (request == null) continue;
            RelationshipFigure rFigure = (RelationshipFigure)request.getSource().getFigure();
            this.execute(new CreateBendpointCommand(rFigure, request));
        }
        this.markAsSaved();
        this.getPaletteViewer().addPaletteListener(new PaletteListener(){

            public void activeToolChanged(final PaletteViewer palette, final ToolEntry tool) {
                if (!PlugIn.isUserMode()) {
                    return;
                }
                List<RelationshipSubtype> subtypes = PlugIn.getRelationshipSubtypes(tool.getLabel());
                if (subtypes == null) {
                    return;
                }
                if (subtypes.size() < 2) {
                    return;
                }
                if (DiagramEditor.this._ignoreMenuSelection) {
                    DiagramEditor.this._ignoreMenuSelection = false;
                    return;
                }
                Menu menu = new Menu(palette.getControl());
                for (final RelationshipSubtype subtype : subtypes) {
                    MenuItem item = new MenuItem(menu, 0);
                    item.setText(subtype.getLabel());
                    item.addSelectionListener(new SelectionListener(){

                        public void widgetSelected(SelectionEvent e) {
                            tool.setToolProperty(CreationTool.PROPERTY_CREATION_FACTORY, (Object)new SimpleFactory(subtype.getGroup().getPartClass()));
                            DiagramEditor.this._ignoreMenuSelection = true;
                            palette.setActiveTool(tool);
                        }

                        public void widgetDefaultSelected(SelectionEvent e) {
                        }
                    });
                }
                menu.setLocation(DiagramEditor.this.getSite().getShell().getDisplay().getCursorLocation());
                menu.setVisible(true);
            }
        });
        this.doSave(null);
    }

    public RootPart getRootPart() {
        return this.getGraphicalViewer() == null ? null : (RootPart)this.getGraphicalViewer().getContents();
    }

    public RootModel getRootModel() {
        return this._root;
    }

    public void createContextMenu(IMenuManager m) {
        this.buildMenu(m);
        this.updateMenuDisplay(m);
        this._menuManager = m;
        m.setVisible(true);
    }

    public static List<DiagramEditor> getEditors() {
        return _editors;
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    private void createContextMenu() {
        this._contextMenu = new MenuManager(UML_CONTEXT_MENU_ID);
        this._contextMenu.setRemoveAllWhenShown(true);
        this._contextMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager m) {
                DiagramEditor.this.createContextMenu(m);
            }
        });
        Control control = this.getGraphicalViewer().getControl();
        Menu menu = this._contextMenu.createContextMenu(control);
        control.setMenu(menu);
    }

    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        GraphicalViewer viewer = this.getGraphicalViewer();
        viewer.setRootEditPart((RootEditPart)new ScalableFreeformRootEditPart());
        viewer.setEditPartFactory((EditPartFactory)new DiagramPartFactory());
        viewer.setKeyHandler(new GraphicalViewerKeyHandler(viewer).setParent(this.getCommonKeyHandler()));
        ActionRegistry registry = this.getActionRegistry();
        List<ContextAction> actions = PlugIn.getActions();
        for (ContextAction action : actions) {
            registry.registerAction((IAction)action);
            int accelerator = action.getAccelerator();
            if (accelerator == 0) continue;
            this.addKeyAction((char)accelerator, action);
        }
        ((FigureCanvas)viewer.getControl()).setScrollBarVisibility(FigureCanvas.ALWAYS);
    }

    public void addKeyAction(char key, ContextAction action) {
        this._sharedKeyHandler.put(KeyStroke.getPressed((char)key, (int)key, (int)0), (IAction)action);
    }

    protected PaletteRoot getPaletteRoot() {
        PaletteRoot pRoot = DiagramPaletteFactory.createPaletteRoot();
        return pRoot;
    }

    public void setFocus() {
        ACTIVE_EDITOR = this;
        for (ContextAction action : PlugIn.getActions()) {
            action.setSelectionProvider(this);
        }
        this.autoSave();
    }

    public static DiagramEditor createEditor(IStructuredSelection selection) throws JavaModelException {
        Object[] objectArray = selection.toArray();
        int n = 0;
        int n2 = objectArray.length;
        while (n < n2) {
            Object element = objectArray[n];
            if (element instanceof IJavaElement) {
                return DiagramEditor.createEditor((IJavaElement)element);
            }
            ++n;
        }
        return null;
    }

    private static DiagramEditor createEditor(IJavaElement element) throws JavaModelException {
        IWorkbenchWindow dwindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage workbenchPage = dwindow.getActivePage();
        IPackageFragment packFrag = null;
        if (element.isReadOnly() || PlugIn.getBooleanPreference("dia.in.project")) {
            element = element.getAncestor(2);
        }
        if (element instanceof IJavaProject) {
            IJavaProject project = (IJavaProject)element;
            packFrag = project.getPackageFragments()[0];
        } else {
            packFrag = !(element instanceof IPackageFragment) ? (IPackageFragment)element.getAncestor(4) : (IPackageFragment)element;
        }
        IPath elementPath = packFrag.getPath().append(String.valueOf(packFrag.getJavaProject().getElementName()) + ".dia");
        try {
            DiagramEditor editor;
            IFile diaFile = DiagramEditor.getFileNotExist(element.getJavaProject().getProject(), elementPath);
            ACTIVE_EDITOR = editor = (DiagramEditor)IDE.openEditor((IWorkbenchPage)workbenchPage, (IFile)diaFile, (boolean)true);
            return editor;
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        _selectionChangedListeners.add((Object)listener);
    }

    public ISelection getSelection() {
        return null;
    }

    public Context getContext() {
        return this._context;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        _selectionChangedListeners.remove((Object)listener);
    }

    public void setSelection(ISelection selection) {
        IStructuredSelection sSelection;
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        if (this._context != null) {
            this._context.getPart().setInitialBackgroundColor();
        }
        if (!((sSelection = (IStructuredSelection)selection).getFirstElement() instanceof AbstractPart)) {
            return;
        }
        this._selection = sSelection;
        this._context = new Context(this._selection);
        AbstractPart part = this._context.getPart();
        if (part != null && part.getParent() instanceof AbstractPart) {
            part.setSelectedBackgroundColor();
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (selection.isEmpty()) {
            return;
        }
        super.selectionChanged(part, selection);
        if (part instanceof DiagramEditor && _outlinePage != null) {
            _outlinePage.setSelection(selection);
        }
        this.setSelection(selection);
    }

    protected KeyHandler getCommonKeyHandler() {
        if (this._sharedKeyHandler == null) {
            this._sharedKeyHandler = new KeyHandler();
        }
        return this._sharedKeyHandler;
    }

    public void execute(Command command) {
        this.getCommandStack().execute(command);
        this.refresh();
    }

    public void commandStackChanged(EventObject event) {
        super.commandStackChanged(event);
        this.checkDirty();
    }

    public void checkDirty() {
        this.firePropertyChange(257);
    }

    public boolean isSaveOnCloseNeeded() {
        return this.isDirty();
    }

    public boolean isDirty() {
        return this.getCommandStack().isDirty();
    }

    public static IFile getFileNotExist(IProject project, IPath path) throws CoreException, IOException {
        IFile file;
        String sPath = path.toOSString();
        int extensionIndex = sPath.lastIndexOf(46);
        String extension = sPath.substring(extensionIndex);
        sPath = sPath.substring(0, extensionIndex);
        int x = 1;
        do {
            IPath newPath = x == 1 ? new Path(String.valueOf(sPath) + extension).removeFirstSegments(1) : new Path(String.valueOf(sPath) + "." + x + extension).removeFirstSegments(1);
            file = project.getFile(newPath);
            ++x;
        } while (file.isAccessible());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        file.create((InputStream)bais, true, null);
        oos.close();
        baos.close();
        bais.close();
        file.refreshLocal(2, null);
        return file;
    }

    public IFile getCurrentFile() {
        IEditorInput input = this.getEditorInput();
        if (input instanceof FileEditorInput) {
            FileEditorInput fInput = (FileEditorInput)input;
            return fInput.getFile();
        }
        return null;
    }

    public void setEditorInput(IEditorInput input) {
        this.setInput(input);
    }

    public void setPartName(String partName) {
        super.setPartName(partName);
    }

    public boolean saveFile(String contents) {
        return this.saveFile(this.getCurrentFile(), contents);
    }

    public void synchronizeCurrentFile() {
        try {
            if (this.getCurrentFile() == null) {
                return;
            }
            this.getCurrentFile().refreshLocal(2, PlugIn.getEmptyProgressMonitor());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public boolean saveFile(IFile iFile, String contents) {
        File file = null;
        if (iFile != null) {
            file = PlugIn.getWorkspaceRoot().getFile(iFile.getFullPath()).getLocation().toFile();
        } else if (this.getEditorInput() instanceof GreenEditorInput) {
            GreenEditorInput input = (GreenEditorInput)this.getEditorInput();
            file = input.getPath().toFile();
        } else {
            GreenException.illegalOperation("Illegal editor input type: " + this.getEditorInput().getClass());
        }
        try {
            FileWriter fWriter = new FileWriter(file);
            PrintWriter pWriter = new PrintWriter(fWriter);
            pWriter.println(contents);
            pWriter.close();
            fWriter.close();
            this.synchronizeCurrentFile();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void markAsSaved() {
        this.getCommandStack().markSaveLocation();
        this.checkDirty();
    }

    public void refresh() {
        this.refresh(false);
    }

    public void refresh(final boolean forceUpdateRelationships) {
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

            public void run() {
                DiagramEditor.this.updateConnectionRouter();
                try {
                    if (DiagramEditor.this.getProject() != null) {
                        IWorkspace w = DiagramEditor.this.getProject().getUnderlyingResource().getWorkspace();
                        w.build(10, null);
                    }
                }
                catch (CoreException coreException) {}
                DiagramEditor.this.refreshRelationships(forceUpdateRelationships);
                DiagramEditor.this.getRootModel().refresh();
            }
        });
        if (_outlinePage != null) {
            _outlinePage.update(this);
        }
    }

    public boolean canUndo() {
        return this.getCommandStack().canUndo();
    }

    public void undo() {
        if (!this.canUndo()) {
            GreenException.illegalOperation("Undo was unsuccessful");
        }
        this.getCommandStack().undo();
    }

    public boolean canRedo() {
        return this.getCommandStack().canRedo();
    }

    public void redo() {
        if (!this.canRedo()) {
            GreenException.illegalOperation("Redo was unsuccessful");
        }
        this.getCommandStack().redo();
    }

    public IMenuManager getMenuManager() {
        return this._menuManager;
    }

    private void findRelationships(IJavaElement element) {
        CompilationUnit cu;
        long modified;
        try {
            if (!element.exists() || !element.isStructureKnown()) {
                return;
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
            return;
        }
        String id = element.getHandleIdentifier();
        Long modifiedStore = this._cuMap.getModificationStamp(id);
        IResource resource = element.getResource();
        if (resource == null) {
            if (this._cuMap.getCompilationUnit(id) != null) {
                modifiedStore = new Long(0L);
            }
            modified = 0L;
        } else {
            modified = resource.getModificationStamp();
        }
        if (modifiedStore == null || modified != modifiedStore) {
            ASTParser parser = ASTParser.newParser((int)3);
            parser.setResolveBindings(true);
            if (element instanceof ICompilationUnit) {
                parser.setSource((ICompilationUnit)element);
            } else if (element instanceof IClassFile) {
                IClassFile classFile = (IClassFile)element;
                try {
                    if (classFile.getSource() == null) {
                        return;
                    }
                }
                catch (JavaModelException e) {
                    e.printStackTrace();
                }
                parser.setSource(classFile);
            } else {
                GreenException.illegalOperation("Illegal element type: " + element.getClass());
            }
            cu = (CompilationUnit)parser.createAST(null);
            this._cuMap.put(element, cu);
        } else {
            cu = this._cuMap.getCompilationUnit(id);
        }
        for (Class klass : PlugIn.getRelationships()) {
            RelationshipRecognizer recognizer = PlugIn.getRelationshipGroup(klass).getRecognizer();
            recognizer.run(cu, this.getRootModel().getRelationshipCache());
        }
    }

    private void refreshRelationships(boolean force) {
        ArrayList<String> visitedElements = new ArrayList<String>();
        ArrayList<String> outdated = new ArrayList<String>();
        if (!force && !PlugIn.isRecognizersEnabled()) {
            return;
        }
        ArrayList<IJavaElement> elements = new ArrayList<IJavaElement>();
        elements.addAll(this.getRootModel().getElementsOfKind(5));
        elements.addAll(this.getRootModel().getElementsOfKind(6));
        for (IJavaElement element : elements) {
            this.findRelationships(element);
            visitedElements.add(element.getHandleIdentifier());
        }
        for (String cu : this._cuMap.keySet()) {
            if (visitedElements.contains(cu)) continue;
            outdated.add(cu);
        }
        for (String obsolete : outdated) {
            this._cuMap.remove(obsolete);
        }
        HashSet<RelationshipModel> toRemove = new HashSet<RelationshipModel>();
        this._relationshipChanges = this.getRootModel().getRelationshipCache().processChanges();
        for (RelationshipModel rModel : this._relationshipChanges) {
            if (rModel.getRelationships().size() == 0) {
                rModel.removeFromParent();
                toRemove.add(rModel);
                continue;
            }
            rModel.setParent(this.getRootModel());
            if (rModel.getSourceModel() == null || rModel.getTargetModel() == null || this.getRootModel().getRelationships().contains(rModel)) continue;
            this.getRootModel().addChild(rModel);
            toRemove.add(rModel);
        }
        for (RelationshipModel model : toRemove) {
            model.updateCardinality();
        }
        this._relationshipChanges.removeAll(toRemove);
    }

    public void autoSave() {
        if (!PlugIn.getBooleanPreference("autoSave")) {
            return;
        }
        IDE.saveAllEditors((IResource[])new IResource[]{PlugIn.getWorkspaceRoot()}, (boolean)false);
    }

    public CompilationUnit getCompilationUnit(IJavaElement element) {
        return this._cuMap.getCompilationUnit(element.getHandleIdentifier());
    }

    public static ConnectionRouter getConnectionRouter() {
        return CONNECTION_ROUTER;
    }

    public static DiagramEditor getActiveEditor() {
        return ACTIVE_EDITOR;
    }

    public ToolEntry getActiveTool() {
        return this.getGraphicalViewer().getEditDomain().getPaletteViewer().getActiveTool();
    }

    public boolean isFiltered(IMember member) throws JavaModelException {
        for (Filter filter : this._filters) {
            if (!filter.accept(member)) continue;
            return true;
        }
        return false;
    }

    public static void setOutlinePage(OutlinePage page) {
        _outlinePage = page;
    }
}

