/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.cse.green.editor;

import edu.buffalo.cse.green.editor.DiagramEditor;
import edu.buffalo.cse.green.editor.OutlineContentProvider;
import edu.buffalo.cse.green.editor.OutlineLabelProvider;
import edu.buffalo.cse.green.editor.controller.AbstractPart;
import org.eclipse.gef.Request;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

public class OutlinePage
extends ContentOutlinePage {
    private OutlineContentProvider _contentProvider;
    private TreeViewer _viewer;
    private IStructuredSelection _sel;
    private static final OutlinePage SINGLETON = new OutlinePage();

    private OutlinePage() {
        DiagramEditor.setOutlinePage(this);
    }

    public static OutlinePage getInstance() {
        return SINGLETON;
    }

    private static DiagramEditor getActiveEditor() {
        return DiagramEditor.getActiveEditor();
    }

    public void update(DiagramEditor editor) {
        if (this._viewer.getContentProvider() == null) {
            return;
        }
        this._viewer.setInput((Object)editor);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this._contentProvider = new OutlineContentProvider();
        this.createActions();
        this._viewer = this.getTreeViewer();
        this._viewer.setContentProvider((IContentProvider)this._contentProvider);
        this._viewer.setLabelProvider((IBaseLabelProvider)new OutlineLabelProvider());
        this.getOutlinePreferences();
        this._viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this._viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                AbstractPart part = OutlinePage.getActiveEditor().getContext().getPart();
                System.err.println((Object)part);
                part.performRequest(new Request((Object)"open"));
            }
        });
        this.initCopyPaste(this._viewer);
        this.createToolbar();
        this.resetToolbarButtons();
        this.createContextMenu();
    }

    public void setSelection(ISelection selection) {
        super.setSelection(selection);
        if (selection.equals(this._sel)) {
            return;
        }
        this._sel = (IStructuredSelection)selection;
        AbstractPart part = (AbstractPart)((Object)this._sel.getFirstElement());
        OutlinePage.getActiveEditor().selectionChanged((IWorkbenchPart)OutlinePage.getActiveEditor(), (ISelection)new StructuredSelection((Object)part));
    }

    public void dispose() {
        super.dispose();
    }

    private void createActions() {
    }

    private void initCopyPaste(TreeViewer viewer) {
    }

    private void getOutlinePreferences() {
    }

    private void resetToolbarButtons() {
    }

    private void createToolbar() {
    }

    private void createContextMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                OutlinePage.getActiveEditor().createContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.getTreeViewer().getControl());
        this.getTreeViewer().getControl().setMenu(menu);
    }
}

