/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.cse.green.editor.action;

import edu.buffalo.cse.green.GreenException;
import edu.buffalo.cse.green.PlugIn;
import edu.buffalo.cse.green.editor.action.ContextAction;
import edu.buffalo.cse.green.editor.action.Submenu;
import edu.buffalo.cse.green.editor.model.commands.SetConstraintCommand;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jdt.core.JavaModelException;

public class UseSizeAction
extends ContextAction {
    public UseSizeAction() {
        super(null);
        this.setAccelerator(115);
    }

    public String getLabel() {
        if (this.isResized()) {
            return "Set to default size";
        }
        return "Set to fixed size";
    }

    protected void doRun() throws JavaModelException {
        String sWidth = PlugIn.getPreference("collapse.width");
        String sHeight = PlugIn.getPreference("collapse.height");
        int height = -1;
        int width = -1;
        if (this.isResized()) {
            SetConstraintCommand command = new SetConstraintCommand(this._model);
            command.setBounds(new Rectangle(this._model.getLocation(), new Dimension(-1, -1)));
            this.getEditor().execute(command);
            this._model.forceRefesh();
        } else {
            try {
                width = Integer.parseInt(sWidth);
                if (width < -1) {
                    width = -1;
                }
            }
            catch (NumberFormatException numberFormatException) {
                GreenException.warn("Cannot parse fixed size: " + sWidth);
            }
            try {
                height = Integer.parseInt(sHeight);
                if (height < -1) {
                    height = -1;
                }
            }
            catch (NumberFormatException numberFormatException) {
                GreenException.warn("Cannot parse fixed size: " + sWidth);
            }
            SetConstraintCommand command = new SetConstraintCommand(this._model);
            command.setBounds(new Rectangle(this._model.getLocation(), new Dimension(width, height)));
            this.getEditor().execute(command);
        }
    }

    protected int getSupportedModels() {
        return 1;
    }

    public Submenu getPath() {
        return Submenu.None;
    }

    public boolean isEnabled() {
        return true;
    }

    private boolean isResized() {
        return !this._model.getSize().equals((Object)new Dimension(-1, -1));
    }
}

