/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.cse.green.editor.controller;

import edu.buffalo.cse.green.PlugIn;
import edu.buffalo.cse.green.editor.controller.JavadocGrabber;
import edu.buffalo.cse.green.editor.controller.MemberPart;
import edu.buffalo.cse.green.editor.controller.RootPart;
import edu.buffalo.cse.green.editor.controller.policies.GreenSelectionEditPolicy;
import edu.buffalo.cse.green.editor.model.AbstractModel;
import edu.buffalo.cse.green.editor.model.CompartmentModel;
import edu.buffalo.cse.green.editor.model.MethodModel;
import edu.buffalo.cse.green.editor.model.TypeModel;
import edu.buffalo.cse.green.editor.model.commands.DeleteCommand;
import edu.buffalo.cse.green.editor.model.commands.DeleteMethodCommand;
import edu.buffalo.cse.green.editor.view.IIconHolder;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPolicy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Display;

public class MethodPart
extends MemberPart {
    protected IFigure doCreateFigure() {
        IIconHolder f = (IIconHolder)this.generateFigure();
        f.setText(this.model().getDisplayName());
        f.setIcon(this.model().getIcon());
        f.setFont(PlugIn.getFontPreference("font", false, false));
        RootPart root = this.getRootPart();
        root.mapModelToEditPart((AbstractModel)this.getModel(), this);
        f.setOpaque(true);
        return f;
    }

    protected IIconHolder getNameLabel() {
        return this.figure();
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("Selection Feedback", (EditPolicy)new GreenSelectionEditPolicy());
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        if (this.figure() != null) {
            this.figure().setText(this.model().getDisplayName());
        }
    }

    public DeleteCommand getDeleteCommand() {
        return new DeleteMethodCommand((MethodModel)this.getModel());
    }

    public void updateIcon() {
        if (Display.getCurrent() != null) {
            this.figure().setIcon(this.model().getIcon());
        } else {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    MethodPart.this.figure().setIcon(MethodPart.this.model().getIcon());
                }
            });
        }
    }

    protected void onDoubleClick() {
        this.getOpenElementAction().run();
    }

    public void updateFont() {
        if (Display.getCurrent() != null) {
            this.updateFontHelper();
        } else {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    MethodPart.this.updateFontHelper();
                }
            });
        }
    }

    private void updateFontHelper() {
        try {
            Font font = this.getFigure().getFont();
            font.dispose();
            TypeModel typeModel = (TypeModel)((CompartmentModel)this.model().getParent()).getParent();
            boolean italic = this.model().isAbstract() && !typeModel.isInterface();
            this.getFigure().setFont(PlugIn.getFontPreference("font", false, italic));
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
    }

    private MethodModel model() {
        return (MethodModel)this.getModel();
    }

    private IIconHolder figure() {
        return (IIconHolder)this.getFigure();
    }

    protected void updateColors(IFigure f) {
        f.setForegroundColor(PlugIn.getColorPreference("color.type.text"));
    }

    public void updateLabel() {
        this.repaintLabel(this.figure());
    }

    protected JavadocGrabber getJavadocGrabber() {
        return new JavadocGrabber(){
            private boolean _alive = true;

            public boolean visit(MethodDeclaration node) {
                if (!this._alive) {
                    return false;
                }
                if (this.compareElements(node.resolveBinding().getJavaElement())) {
                    this._alive = false;
                    this._doc = MethodPart.this.getDoc(node.getJavadoc());
                }
                return this._alive;
            }
        };
    }
}

