/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.cse.green.editor.controller;

import edu.buffalo.cse.green.PlugIn;
import edu.buffalo.cse.green.editor.DiagramEditor;
import edu.buffalo.cse.green.editor.controller.AbstractPart;
import edu.buffalo.cse.green.editor.controller.PropertyChange;
import edu.buffalo.cse.green.editor.controller.PropertyListener;
import edu.buffalo.cse.green.editor.controller.policies.DiagramLayoutEditPolicy;
import edu.buffalo.cse.green.editor.controller.policies.GreenSelectionEditPolicy;
import edu.buffalo.cse.green.editor.model.AbstractModel;
import edu.buffalo.cse.green.editor.model.RelationshipModel;
import edu.buffalo.cse.green.editor.model.commands.DeleteCommand;
import edu.buffalo.cse.green.editor.view.RootFigure;
import edu.buffalo.cse.green.relationships.RelationshipGenerator;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.draw2d.FreeformLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.tools.MarqueeDragTracker;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class RootPart
extends AbstractPart {
    private HashMap<AbstractModel, AbstractPart> _modelToEditPartMap = new HashMap();
    private DiagramEditor _editor;

    protected void removeChild(EditPart child) {
        AbstractModel model;
        if (child instanceof AbstractPart && this.getPartFromModel(model = (AbstractModel)child.getModel()) == child) {
            this.unmapModelFromEditPart(model);
        }
        super.removeChild(child);
    }

    protected IFigure doCreateFigure() {
        RootFigure f = new RootFigure();
        f.setLayoutManager((LayoutManager)new FreeformLayout());
        f.setOpaque(true);
        f.setSize(new Dimension(1000, 1000));
        return f;
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new DiagramLayoutEditPolicy((XYLayout)this.getContentPane().getLayoutManager()));
        this.installEditPolicy("Selection Feedback", (EditPolicy)new GreenSelectionEditPolicy());
    }

    public DragTracker getDragTracker(Request req) {
        return new RootPartDragTracker((EditPart)this);
    }

    public RootPart getRootPart() {
        return this;
    }

    public void mapModelToEditPart(AbstractModel model, AbstractPart part) {
        this._modelToEditPartMap.put(model, part);
    }

    public void unmapModelFromEditPart(AbstractModel model) {
        this._modelToEditPartMap.remove(model);
    }

    public AbstractPart getPartFromModel(AbstractModel model) {
        return this._modelToEditPartMap.get(model);
    }

    public DeleteCommand getDeleteCommand() {
        return null;
    }

    public void setEditor(DiagramEditor editor) {
        this._editor = editor;
    }

    public DiagramEditor getEditor() {
        return this._editor;
    }

    public void addPropertyListeners() {
        this.addListener(PropertyChange.Children, new RootChildHandler());
        this.addListener(PropertyChange.GenerateRelationship, new RelationshipGenerationHandler());
        this.addListener(PropertyChange.UpdateRelationships, new RelationshipUpdateHandler());
    }

    protected void onDoubleClick() {
    }

    protected void updateColors(IFigure f) {
    }

    public void setInitialBackgroundColor() {
    }

    class RootPartDragTracker
    extends MarqueeDragTracker {
        protected static final int TOGGLE_MODE = 1;
        protected static final int APPEND_MODE = 2;
        private int _mode;
        private EditPart _startingEditPart;

        public RootPartDragTracker(EditPart startingEditPart) {
            this._startingEditPart = startingEditPart;
        }

        protected boolean handleButtonDown(int button) {
            if ((this.getState() & 1) != 0) {
                if (this.getCurrentInput().isControlKeyDown()) {
                    this._mode = 1;
                } else if (this.getCurrentInput().isShiftKeyDown()) {
                    this._mode = 2;
                }
            }
            return super.handleButtonDown(button);
        }

        protected boolean handleButtonUp(int button) {
            EditPartViewer viewer = this.getCurrentViewer();
            if ((this.getState() & 4) != 0 && this.getStartLocation().equals((Object)this.getLocation())) {
                if (this._mode == 2) {
                    viewer.appendSelection(this._startingEditPart);
                } else if (this._mode == 1) {
                    ArrayList<EditPart> selected = new ArrayList<EditPart>((ArrayList)viewer.getSelectedEditParts());
                    if (selected.contains(this._startingEditPart)) {
                        selected.remove(this._startingEditPart);
                    } else {
                        selected.add(this._startingEditPart);
                    }
                    viewer.setSelection((ISelection)new StructuredSelection(selected));
                } else {
                    viewer.select(this._startingEditPart);
                }
            }
            boolean result = super.handleButtonUp(button);
            return result;
        }
    }

    class RelationshipGenerationHandler
    implements PropertyListener {
        RelationshipGenerationHandler() {
        }

        public void notify(Object oValue, Object nValue) {
            RelationshipModel rModel = (RelationshipModel)nValue;
            RelationshipGenerator rGenerator = PlugIn.getRelationshipGroup(rModel.getPartClass()).getGenerator();
            rGenerator.accept(rGenerator.getCompilationUnit(rModel.getSourceType()));
            rModel.getSourceModel().updateFields();
            rModel.getSourceModel().updateMethods();
            RootPart.this.getEditor().autoSave();
            RootPart.this.getEditor().refresh();
        }
    }

    class RelationshipUpdateHandler
    implements PropertyListener {
        RelationshipUpdateHandler() {
        }

        public void notify(Object oValue, Object nValue) {
            RootPart.this.getEditor().refresh();
        }
    }

    class RootChildHandler
    implements PropertyListener {
        RootChildHandler() {
        }

        public void notify(Object oValue, Object nValue) {
            if (oValue == null) {
                AbstractModel model = (AbstractModel)nValue;
                model.assertValid();
            }
        }
    }
}

