/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.cse.green.editor.controller.policies;

import edu.buffalo.cse.green.GreenException;
import edu.buffalo.cse.green.PlugIn;
import edu.buffalo.cse.green.editor.controller.RelationshipPart;
import edu.buffalo.cse.green.editor.model.RelationshipModel;
import edu.buffalo.cse.green.editor.model.RootModel;
import edu.buffalo.cse.green.editor.model.TypeModel;
import edu.buffalo.cse.green.relationships.RelationshipGenerator;
import edu.buffalo.cse.green.relationships.RelationshipGroup;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class CreateRelationshipCommand
extends Command {
    private static boolean _forceCardinality = false;
    private static int _forcedCardinality;
    private RelationshipPart _relationshipPart;
    private RootModel _root;

    public CreateRelationshipCommand() {
        this._relationshipPart = null;
    }

    public CreateRelationshipCommand(RootModel model, RelationshipPart part) {
        this.setRoot(model);
        this._relationshipPart = part;
        this.getModel().setParent(this._root);
        RelationshipGroup group = PlugIn.getRelationshipGroup(part.getClass());
        group.setVisible(true);
        this._root.showRelationshipsOfType(part.getClass());
    }

    public RelationshipModel getRelationship() {
        return (RelationshipModel)this._relationshipPart.getModel();
    }

    public void setSource(TypeModel source) {
        this.getModel().setSourceModel(source);
    }

    public void setTarget(TypeModel target) {
        this.getModel().setTargetModel(target);
    }

    public void execute() {
        Class<?> klass = this._relationshipPart.getClass();
        this.getModel().setPartClass(klass);
        try {
            this.getModel().assertValid();
        }
        catch (GreenException e) {
            if (PlugIn.isUserMode()) {
                MessageDialog.openError((Shell)PlugIn.getDefaultShell(), (String)"Relationship", (String)e.getLocalizedMessage());
                return;
            }
            throw e;
        }
        RelationshipGenerator rGen = PlugIn.getRelationshipGroup(klass).getGenerator();
        if (!rGen.setRelationship(this.getModel())) {
            return;
        }
        if (rGen.supportsCardinality()) {
            int cardinality = 1;
            if (!_forceCardinality) {
                InputDialog dialog = new InputDialog(PlugIn.getDefaultShell(), "Cardinality", "Enter a cardinality", "1", new IInputValidator(){

                    public String isValid(String newText) {
                        Pattern p = Pattern.compile("\\*|\\d+|\\d+\\.\\.\\*");
                        Matcher m = p.matcher(newText);
                        if (m.matches()) {
                            return null;
                        }
                        return "Cardinality needs to be either a quantity or '#..*' or *";
                    }
                });
                if (dialog.open() == 1) {
                    return;
                }
                if (dialog.getValue().equals("*")) {
                    cardinality = 0;
                } else {
                    try {
                        cardinality = Integer.parseInt(dialog.getValue());
                    }
                    catch (NumberFormatException numberFormatException) {
                        int i = dialog.getValue().indexOf(".");
                        String card = dialog.getValue().substring(0, i);
                        cardinality = -1 * Integer.parseInt(card);
                    }
                }
            } else {
                cardinality = _forcedCardinality;
            }
            _forceCardinality = false;
            rGen.setCardinality(cardinality);
        }
        this._root.generateRelationshipCode(this.getModel());
    }

    public void setRoot(RootModel root) {
        this._root = root;
    }

    public RootModel getRoot() {
        return this._root;
    }

    public boolean canUndo() {
        return false;
    }

    private RelationshipModel getModel() {
        return (RelationshipModel)this._relationshipPart.getModel();
    }

    public static void forceCardinality(int cardinality) {
        _forceCardinality = true;
        _forcedCardinality = cardinality;
    }
}

