/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.cse.green.editor.model.commands;

import edu.buffalo.cse.green.editor.model.RelationshipModel;
import edu.buffalo.cse.green.editor.model.RootModel;
import edu.buffalo.cse.green.editor.model.TypeModel;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.commands.Command;

public class HideTypeCommand
extends Command {
    private TypeModel _typeModel;
    private List<RelationshipModel> _hiddenRelationships;

    public HideTypeCommand(TypeModel typeModel) {
        this._typeModel = typeModel;
        this._hiddenRelationships = new ArrayList<RelationshipModel>();
    }

    public void execute() {
        super.execute();
        this._typeModel.setVisible(false);
        for (RelationshipModel rModel : this._typeModel.getOutgoingEdges()) {
            if (rModel.isVisible()) {
                this._hiddenRelationships.add(rModel);
            }
            rModel.showRelationshipExplicitly(false);
        }
        for (RelationshipModel rModel : this._typeModel.getIncomingEdges()) {
            if (rModel.isVisible()) {
                this._hiddenRelationships.add(rModel);
            }
            rModel.showRelationshipExplicitly(false);
        }
    }

    public void undo() {
        this._typeModel.setVisible(true);
        for (RelationshipModel rModel : this._hiddenRelationships) {
            if (!((RootModel)this._typeModel.getParent()).getChildren().contains(rModel) || !rModel.getSourceModel().isVisible() || !rModel.getTargetModel().isVisible()) continue;
            rModel.showRelationshipExplicitly(true);
        }
    }

    public void redo() {
        this.execute();
    }
}

