/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.cse.green.editor.model.commands;

import edu.buffalo.cse.green.PlugIn;
import edu.buffalo.cse.green.editor.DiagramEditor;
import edu.buffalo.cse.green.editor.model.RelationshipModel;
import edu.buffalo.cse.green.editor.model.RootModel;
import edu.buffalo.cse.green.editor.model.TypeModel;
import edu.buffalo.cse.green.editor.model.commands.AddJavaElementCommand;
import edu.buffalo.cse.green.relationships.RelationshipGroup;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.gef.commands.Command;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IncrementalExploreCommand
extends Command {
    private TypeModel _model;
    private DiagramEditor _editor;
    private List<Command> _commands;
    private List<RelationshipGroup> _relTypes;

    public IncrementalExploreCommand(DiagramEditor editor, TypeModel model) {
        this(editor, model, PlugIn.getRelationshipGroups());
    }

    public IncrementalExploreCommand(DiagramEditor editor, TypeModel model, List<RelationshipGroup> relationshipGroups) {
        this._model = model;
        this._editor = editor;
        this._commands = new ArrayList<Command>();
        this._relTypes = relationshipGroups;
    }

    public void execute() {
        this._editor.refresh(true);
        this._commands.clear();
        IType type = this._model.getType();
        RootModel root = this._editor.getRootModel();
        Set<RelationshipModel> relationships = root.getRelationshipCache().getRelationships(type);
        for (RelationshipModel rModel : relationships) {
            if (!rModel.getRelationshipGroup().isVisible()) continue;
            IType tType = rModel.getTargetType();
            if (!this._relTypes.contains(rModel.getRelationshipGroup()) || root.getModelFromType(tType) != null) continue;
            AddJavaElementCommand command = new AddJavaElementCommand(this._editor, (IJavaElement)tType);
            this._commands.add(command);
            command.execute();
        }
        if (this._commands.size() > 0) {
            this._editor.refresh();
        } else {
            MessageDialog.openInformation((Shell)this._editor.getSite().getShell(), (String)"Incremental Exploration", (String)("Exploration of that type is already complete: " + this._model.getDisplayName()));
        }
    }

    public void undo() {
        for (Command command : this._commands) {
            command.undo();
        }
    }

    public void redo() {
        this.execute();
    }
}

