/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.cse.green.editor.model.filters;

import edu.buffalo.cse.green.GreenException;
import edu.buffalo.cse.green.editor.model.filters.MemberVisibility;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;

public class MemberFilter {
    private Set<Integer> _type = new HashSet<Integer>();
    private MemberVisibility _visibility;
    private String _nameMatcher;
    private int _enabled;

    public MemberFilter(int enabled, boolean types, boolean fields, boolean methods, MemberVisibility visibility, String nameMatcher) {
        if (types) {
            this._type.add(7);
        }
        if (fields) {
            this._type.add(8);
        }
        if (methods) {
            this._type.add(9);
        }
        this._enabled = enabled;
        this._visibility = visibility;
        this._nameMatcher = nameMatcher;
    }

    public MemberFilter(String genKey) {
        this(Integer.parseInt(genKey.substring(0, 1)), genKey.substring(1, 2).equals("1"), genKey.substring(2, 3).equals("1"), genKey.substring(3, 4).equals("1"), MemberVisibility.makeVisibility(Integer.parseInt(genKey.substring(4, 5))), genKey.substring(5));
    }

    public boolean isFiltered(IMember member) {
        boolean condition;
        IType type;
        block6: {
            try {
                if (this._enabled >= 2) break block6;
                return false;
            }
            catch (Exception exception) {
                GreenException.warn("Problem with filter: " + this);
                return false;
            }
        }
        String memberName = member.getElementName();
        if (member.getElementType() == 7) {
            type = (IType)member;
        } else {
            type = member.getDeclaringType();
            memberName = String.valueOf(type.getElementName()) + "." + memberName;
        }
        String packageName = type.getPackageFragment().getElementName();
        String qualifiedName = String.valueOf(packageName) + "." + type.getCompilationUnit().getElementName() + "." + memberName;
        boolean bl = condition = this._type.contains(member.getElementType()) && this._visibility.match(member) && Pattern.matches("\\b" + this._nameMatcher.replace(".", "\\.").replace("?", ".").replace("*", ".*") + "\\b", qualifiedName);
        if (this._enabled % 2 == 0) {
            return condition;
        }
        return !condition;
    }

    public String toString() {
        return String.valueOf(this._enabled) + (this._type.contains(7) ? "1" : "0") + (this._type.contains(8) ? "1" : "0") + (this._type.contains(9) ? "1" : "0") + this._visibility.toString() + this._nameMatcher;
    }

    public boolean isEnabled() {
        return this._enabled >= 2;
    }

    public int getEnabledValue() {
        return this._enabled;
    }

    public String getDescription() {
        StringBuffer buf = new StringBuffer();
        String[] members = new String[]{"type, ", "field, ", "method, "};
        buf.append(this._enabled % 2 == 0 ? "" : "not: ");
        buf.append(this._type.contains(7) ? members[0] : "");
        buf.append(this._type.contains(8) ? members[1] : "");
        buf.append(this._type.contains(9) ? members[2] : "");
        buf.append("with " + this._visibility.getCodeText() + " visibility ");
        buf.append("that matches pattern: " + this._nameMatcher);
        return buf.toString();
    }

    public void setEnabled(int enabled) {
        this._enabled = enabled;
    }
}

