/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.cse.green.editor.model.filters;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum MemberVisibility {
    ANY("any", 3),
    DEFAULT("default", null, 0),
    PRIVATE("private", 2),
    PROTECTED("protected", 4),
    PUBLIC("public", 1);

    private int _visibility;
    private String _codeText;
    private String _name;
    private static Map<Integer, MemberVisibility> _visMap;

    private MemberVisibility(String name, int visibility) {
        this(name, name, visibility);
    }

    private MemberVisibility(String name, String codeText, int visibility) {
        this._codeText = codeText;
        this._name = name;
        this._visibility = visibility;
        this.addVisibilityMapping(visibility, this);
    }

    private void addVisibilityMapping(int visibilityNum, MemberVisibility visibility) {
        if (_visMap == null) {
            _visMap = new HashMap<Integer, MemberVisibility>();
        }
        _visMap.put(visibilityNum, visibility);
    }

    public boolean match(IMember member) {
        if (this._visibility == MemberVisibility.ANY._visibility) {
            return true;
        }
        try {
            IType parent;
            if (member.getParent() instanceof IType && (parent = (IType)member.getParent()).isInterface()) {
                return this._visibility == 1;
            }
            return (member.getFlags() & this._visibility) == this._visibility;
        }
        catch (JavaModelException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static MemberVisibility makeVisibility(int visibility) {
        return _visMap.get(visibility);
    }

    public String toString() {
        return "" + this._visibility;
    }

    public int intValue() {
        return this._visibility;
    }

    public String getName() {
        return this._name;
    }

    public String getCodeText() {
        return this._codeText;
    }
}

