/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.cse.green.relationships;

import edu.buffalo.cse.green.GreenException;
import edu.buffalo.cse.green.PlugIn;
import edu.buffalo.cse.green.dialogs.ChooseTypeWizard;
import edu.buffalo.cse.green.editor.model.RelationshipModel;
import edu.buffalo.cse.green.preferences.VariableAffix;
import edu.buffalo.cse.green.relationships.RelationshipCache;
import edu.buffalo.cse.green.relationships.RelationshipVisitor;
import edu.buffalo.cse.green.util.IModifiableBuffer;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.text.edits.TextEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RelationshipGenerator
extends RelationshipVisitor {
    private IType _sourceType;
    private IType _actualTargetType;
    private IType _declaredTargetType;
    protected int _cardinality = 1;
    public static final String LIST = "java.util.List";
    public static final String ARRAYLIST = "java.util.ArrayList";

    protected boolean addImport(IType type) {
        if (this.getCurrentType().getParent().equals(type.getParent())) {
            return true;
        }
        if (this.getSourceType().getCompilationUnit().equals(this.getSourceType().getParent()) && this.getTargetType().getOpenable().equals(this.getTargetType().getParent()) && this.getSourceType().getPackageFragment().equals(this.getTargetType().getPackageFragment())) {
            return true;
        }
        return this.addImport(this.createQualifiedName(type.getFullyQualifiedName().replace('$', '.')));
    }

    private boolean addImport(QualifiedName qualifiedName) {
        AbstractList imports = (AbstractList)this.getCompilationUnit().imports();
        for (ImportDeclaration declaration : imports) {
            String elementName;
            if (declaration.isOnDemand()) continue;
            if (new ASTMatcher().match((QualifiedName)declaration.getName(), (Object)qualifiedName)) {
                return true;
            }
            if (declaration.resolveBinding() == null || !(elementName = declaration.resolveBinding().getJavaElement().getElementName()).equals(qualifiedName.getName().toString())) continue;
            return false;
        }
        ImportDeclaration i = this.getAST().newImportDeclaration();
        i.setName((Name)qualifiedName);
        imports.add(i);
        return true;
    }

    protected QualifiedName createQualifiedName(String fullyQualifiedString) {
        int index;
        AST ast = this.getAST();
        if (fullyQualifiedString.indexOf(".") == -1) {
            GreenException.illegalOperation("String must be fully qualified");
        }
        int prevIndex = fullyQualifiedString.indexOf(".");
        String qual = fullyQualifiedString.substring(0, prevIndex);
        SimpleName qualifier = ast.newSimpleName(qual);
        while ((index = (qual = fullyQualifiedString.substring(prevIndex + 1)).indexOf(".")) != -1) {
            qual = fullyQualifiedString.substring(prevIndex + 1, (index += prevIndex) + 1);
            qualifier = ast.newQualifiedName((Name)qualifier, ast.newSimpleName(qual));
            prevIndex = index + 1;
        }
        return ast.newQualifiedName((Name)qualifier, ast.newSimpleName(qual));
    }

    @Override
    protected void run(CompilationUnit cu, RelationshipCache cache) {
        try {
            if (this._sourceType.isBinary()) {
                GreenException.illegalOperation("A relationship cannot be generated with a binary type as its source.");
            }
            ICompilationUnit iCU = (ICompilationUnit)this.getSourceType().getAncestor(5);
            cu.recordModifications();
            cu.accept((ASTVisitor)this);
            IModifiableBuffer sourceDoc = new IModifiableBuffer(iCU.getBuffer());
            TextEdit textEdit = cu.rewrite((IDocument)sourceDoc, null);
            textEdit.apply((IDocument)sourceDoc);
            if (!iCU.isConsistent()) {
                iCU.save(PlugIn.getEmptyProgressMonitor(), true);
            }
            this.organizeImports(this._sourceType);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
    }

    protected IType getSourceType() {
        return this._sourceType;
    }

    protected IType getTargetType() {
        return this._declaredTargetType;
    }

    public static Name getQualifier(Name name) {
        if (name.isSimpleName()) {
            return null;
        }
        QualifiedName qualName = (QualifiedName)name;
        return qualName.getQualifier();
    }

    public boolean setRelationship(RelationshipModel rModel) {
        this._sourceType = rModel.getSourceType();
        this._declaredTargetType = rModel.getTargetType();
        if (this.needChooseTypeDialog()) {
            ChooseTypeWizard wizard = new ChooseTypeWizard(this.getTargetType());
            WizardDialog dialog = new WizardDialog(PlugIn.getDefaultShell(), (IWizard)wizard);
            dialog.setMinimumPageSize(300, 500);
            dialog.create();
            int res = dialog.open();
            if (res == 1) {
                return false;
            }
            this.setActualTargetType(wizard.getSelectedType());
        }
        return true;
    }

    protected abstract boolean needChooseTypeDialog();

    public boolean supportsCardinality() {
        return false;
    }

    public void setCardinality(int cardinality) {
        if (!this.supportsCardinality()) {
            GreenException.illegalOperation("Cannot set the cardinality of a non-cardinal relationship type");
        }
        this._cardinality = cardinality;
    }

    public void setSourceType(IType selectedType) {
        this._sourceType = selectedType;
    }

    public void setTargetType(IType selectedType) {
        this._declaredTargetType = selectedType;
    }

    protected Type createTypeReference(IType type) {
        boolean success = this.addImport(type);
        if (success) {
            return this.getAST().newSimpleType((Name)this.getAST().newSimpleName(type.getElementName()));
        }
        return this.getAST().newSimpleType((Name)this.createQualifiedName(type.getFullyQualifiedName()));
    }

    private Type createTypeReference(QualifiedName name) {
        AST ast = this.getAST();
        boolean success = this.addImport(name);
        if (success) {
            return ast.newSimpleType((Name)ast.newSimpleName(name.getName().toString()));
        }
        return ast.newSimpleType((Name)name);
    }

    protected abstract boolean process(Block var1);

    protected abstract boolean doVisitBlocks();

    public final boolean visit(Block node) {
        if (this.doVisitBlocks()) {
            for (Statement stmt : (AbstractList)node.statements()) {
                if (stmt.getNodeType() != 60) continue;
                VariableDeclarationStatement vds = (VariableDeclarationStatement)stmt;
                AbstractList vdfs = (AbstractList)vds.fragments();
                for (VariableDeclarationFragment vdf : vdfs) {
                    this.getLocalDeclarations().add(vdf.getName().getIdentifier());
                }
            }
            this.process(node);
        }
        return true;
    }

    public final void endVisit(Block node) {
        this.getLocalDeclarations().clear();
    }

    protected VariableDeclarationStatement createNormalVariableDeclaration(IType targetType, String name, Expression value) {
        return this.createVariableDeclaration(targetType, name, value, false);
    }

    protected VariableDeclarationStatement createGenericVariableDeclaration(IType targetType, String name) {
        this.addImport(this.createQualifiedName(ARRAYLIST));
        ClassInstanceCreation cic = this.getAST().newClassInstanceCreation();
        cic.setType(this.createParameterizedTypeReference(ARRAYLIST, this.createTypeReference(targetType)));
        return this.createVariableDeclaration(targetType, name, (Expression)cic, true);
    }

    protected Type createParameterizedTypeReference(String collection, Type targetType) {
        ParameterizedType pType = this.getAST().newParameterizedType(this.createTypeReference(this.createQualifiedName(collection)));
        pType.setType(this.createTypeReference(this.createQualifiedName(collection)));
        AbstractList types = (AbstractList)((List)pType.getStructuralProperty((StructuralPropertyDescriptor)ParameterizedType.TYPE_ARGUMENTS_PROPERTY));
        types.add(targetType);
        return pType;
    }

    private VariableDeclarationStatement createVariableDeclaration(IType targetType, String name, Expression value, boolean isGeneric) {
        VariableDeclarationFragment vdf = this.getAST().newVariableDeclarationFragment();
        vdf.setInitializer(value);
        vdf.setName(this.getAST().newSimpleName(name));
        VariableDeclarationStatement vds = this.getAST().newVariableDeclarationStatement(vdf);
        if (isGeneric) {
            vds.setType(this.createParameterizedTypeReference(LIST, this.createTypeReference(targetType)));
        } else {
            vds.setType(this.createTypeReference(targetType));
        }
        return vds;
    }

    protected ClassInstanceCreation createInvocation(Type type) {
        ClassInstanceCreation cic = this.getAST().newClassInstanceCreation();
        cic.setType(type);
        return cic;
    }

    protected ClassInstanceCreation createParameterizedInvocation(Type type) {
        return this.createInvocation(this.createParameterizedTypeReference(ARRAYLIST, type));
    }

    protected String getBaseVariableName() {
        return String.valueOf(this.getTargetType().getElementName().toLowerCase().charAt(0)) + this.getTargetType().getElementName().substring(1);
    }

    private List<String> generateVariableList() {
        ArrayList<String> vars = new ArrayList<String>();
        vars.addAll(this.getParameterDeclarations());
        vars.addAll(this.getLocalDeclarations());
        vars.addAll(this.getFieldNames());
        return vars;
    }

    protected String generateVariableName(String base) {
        List<String> variables = this.generateVariableList();
        String varName = base;
        int x = 2;
        while (variables.contains(varName)) {
            varName = String.valueOf(base) + x;
            ++x;
        }
        return varName;
    }

    protected boolean addField(Type type, String name) {
        if (this.isFieldDeclared(name)) {
            return false;
        }
        AbstractList decs = (AbstractList)this.getCurrentTypeDeclaration().bodyDeclarations();
        VariableDeclarationFragment vdf = this.getAST().newVariableDeclarationFragment();
        FieldDeclaration dec = this.getAST().newFieldDeclaration(vdf);
        AbstractList modifiers = (AbstractList)dec.modifiers();
        modifiers.add(this.getAST().newModifier(Modifier.ModifierKeyword.PRIVATE_KEYWORD));
        dec.setType(type);
        vdf.setName(this.getAST().newSimpleName(name));
        decs.add(0, dec);
        this.getFields().add(0, dec);
        return true;
    }

    protected Assignment createAssignment(String name, Expression value) {
        SimpleName lhs;
        Assignment ass = this.getAST().newAssignment();
        SimpleName field = this.getAST().newSimpleName(name);
        if (this.getParameterDeclarations().contains(name)) {
            FieldAccess exp = this.getAST().newFieldAccess();
            ThisExpression thisExp = this.getAST().newThisExpression();
            exp.setExpression((Expression)thisExp);
            exp.setName(field);
            lhs = exp;
        } else {
            lhs = field;
        }
        ass.setLeftHandSide((Expression)lhs);
        ass.setRightHandSide(value);
        return ass;
    }

    protected boolean correctTypeToGenerate() {
        return this.getSourceType().equals(this.getCurrentType());
    }

    protected void addParameterizedParameter(MethodDeclaration method, IType type, String paramName) {
        this.addParameter(method, this.createParameterizedTypeReference(LIST, this.createTypeReference(type)), paramName);
    }

    protected void addNormalParameter(MethodDeclaration method, IType type, String paramName) {
        this.addParameter(method, this.createTypeReference(type), paramName);
    }

    private void addParameter(MethodDeclaration method, Type type, String paramName) {
        AbstractList params = (AbstractList)method.parameters();
        SingleVariableDeclaration svd = this.getAST().newSingleVariableDeclaration();
        svd.setType(type);
        svd.setName(this.getAST().newSimpleName(paramName));
        params.add(svd);
    }

    private void setActualTargetType(IType type) {
        this._actualTargetType = type;
    }

    protected IType getActualTargetType() {
        if (this._actualTargetType == null) {
            return this._declaredTargetType;
        }
        return this._actualTargetType;
    }

    protected SimpleName name(String text) {
        return this.getAST().newSimpleName(text);
    }

    protected ExpressionStatement createMethodInvocation(String variable, String method, List<Expression> arguments) {
        MethodInvocation m = this.getAST().newMethodInvocation();
        m.setExpression((Expression)this.name(variable));
        m.setName(this.name(method));
        AbstractList args = (AbstractList)m.arguments();
        args.addAll(arguments);
        return this.getAST().newExpressionStatement((Expression)m);
    }

    protected String getVariableAffix(VariableAffix affix) {
        return JavaCore.getPlugin().getPluginPreferences().getString(affix.getPreferenceId().split(",")[0]);
    }
}

