/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.cse.green.relationship.generalization;

import edu.buffalo.cse.green.GreenException;
import edu.buffalo.cse.green.relationships.DeclarationInfoProvider;
import edu.buffalo.cse.green.relationships.RelationshipGenerator;
import java.util.AbstractList;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.Type;

public class GeneralizationGenerator
extends RelationshipGenerator {
    private static final String CLASS_MULTIPLE_GENERALIZATION = "A class may not generalize multiple classes";

    public boolean process(DeclarationInfoProvider node) {
        if (!this.correctTypeToGenerate()) {
            return true;
        }
        try {
            if (this.getSourceType().isInterface()) {
                Type type = this.createTypeReference(this.getTargetType());
                AbstractList interfaceList = (AbstractList)node.getSuperInterfaceTypes();
                for (Type eType : interfaceList) {
                    if (!this.getType(eType).equals(this.getTargetType())) continue;
                    GreenException.illegalOperation((String)"Duplicate generalization of target interface");
                }
                interfaceList.add(type);
            } else {
                if (node.getSuperclassType() != null) {
                    GreenException.illegalOperation((String)CLASS_MULTIPLE_GENERALIZATION);
                }
                node.setSuperclassType(this.createTypeReference(this.getTargetType()));
            }
            return false;
        }
        catch (JavaModelException e) {
            e.printStackTrace();
            return false;
        }
    }

    protected boolean process(Block node) {
        return false;
    }

    protected boolean doVisitBlocks() {
        return false;
    }

    protected boolean needChooseTypeDialog() {
        return false;
    }
}

