/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.cse.green.editor;

import edu.buffalo.cse.green.PlugIn;
import edu.buffalo.cse.green.RelationshipSubtype;
import edu.buffalo.cse.green.editor.RelationshipCreationToolEntry;
import edu.buffalo.cse.green.editor.model.NoteModel;
import edu.buffalo.cse.green.editor.model.TypeModel;
import edu.buffalo.cse.green.relationships.RelationshipGroup;
import edu.buffalo.cse.green.types.ITypeProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.eclipse.gef.palette.CombinedTemplateCreationEntry;
import org.eclipse.gef.palette.PaletteGroup;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.PanningSelectionToolEntry;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.requests.SimpleFactory;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jface.resource.ImageDescriptor;

class DiagramPaletteFactory {
    private static ToolEntry SELECTION_TOOL = new PanningSelectionToolEntry("Select", "Select Anything");

    DiagramPaletteFactory() {
    }

    public static ToolEntry getSelectionTool() {
        return SELECTION_TOOL;
    }

    public static PaletteRoot createPaletteRoot() {
        ImageDescriptor noteIcon = JavaPluginImages.DESC_TOOL_SHOW_SEGMENTS;
        PaletteRoot paletteRoot = new PaletteRoot();
        Vector<PaletteGroup> categories = new Vector<PaletteGroup>();
        PaletteGroup tools = new PaletteGroup("Group");
        Vector<ToolEntry> selectEntries = new Vector<ToolEntry>();
        Vector<CombinedTemplateCreationEntry> typeEntries = new Vector<CombinedTemplateCreationEntry>();
        Vector<RelationshipCreationToolEntry> relEntries = new Vector<RelationshipCreationToolEntry>();
        String noteLabel = "Note";
        String noteDesc = "Create Note Diagram";
        selectEntries.add(SELECTION_TOOL);
        paletteRoot.setDefaultEntry(SELECTION_TOOL);
        tools.addAll(selectEntries);
        PaletteGroup typeDrawer = new PaletteGroup("Create Type");
        ArrayList<ITypeProperties> properties = new ArrayList<ITypeProperties>();
        for (ITypeProperties prop : PlugIn.getAvailableTypes()) {
            boolean added = false;
            int x = 0;
            for (ITypeProperties cProp : properties) {
                if (prop.getLabel().compareToIgnoreCase(cProp.getLabel()) < 0) {
                    properties.add(x, prop);
                    added = true;
                    break;
                }
                ++x;
            }
            if (added) continue;
            properties.add(prop);
        }
        for (ITypeProperties prop : properties) {
            typeEntries.add(new CombinedTemplateCreationEntry(prop.getLabel(), prop.getDescription(), TypeModel.class, (CreationFactory)new SimpleFactory(TypeModel.class), prop.getIconDescriptor(), null));
        }
        typeEntries.add(new CombinedTemplateCreationEntry(noteLabel, noteDesc, NoteModel.class, (CreationFactory)new SimpleFactory(NoteModel.class), noteIcon, null));
        typeDrawer.addAll(typeEntries);
        PaletteGroup relDrawer = new PaletteGroup("Relationships");
        ArrayList<Class> relClasses = new ArrayList<Class>();
        for (Class klass : PlugIn.getRelationships()) {
            boolean added = false;
            int x = 0;
            for (Class comp : relClasses) {
                if (PlugIn.getRelationshipName(klass).compareToIgnoreCase(PlugIn.getRelationshipName(comp)) < 0) {
                    relClasses.add(x, klass);
                    added = true;
                    break;
                }
                ++x;
            }
            if (added) continue;
            relClasses.add(klass);
        }
        String oldName = null;
        for (Class klass : relClasses) {
            RelationshipGroup group = PlugIn.getRelationshipGroup(klass);
            if (group.getName().equals(oldName)) continue;
            oldName = group.getName();
            List<RelationshipSubtype> subtypes = PlugIn.getRelationshipSubtypes(group.getName());
            RelationshipCreationToolEntry entry = new RelationshipCreationToolEntry(group, subtypes);
            relEntries.add(entry);
        }
        relDrawer.addAll(relEntries);
        categories.add(tools);
        categories.add(typeDrawer);
        categories.add(relDrawer);
        paletteRoot.addAll(categories);
        return paletteRoot;
    }
}

