/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.cse.green.editor.action;

import edu.buffalo.cse.green.GreenException;
import edu.buffalo.cse.green.dialogs.NewMethodWizard;
import edu.buffalo.cse.green.editor.DiagramEditor;
import edu.buffalo.cse.green.editor.action.ContextAction;
import edu.buffalo.cse.green.editor.action.Submenu;
import edu.buffalo.cse.green.editor.model.TypeModel;
import edu.buffalo.cse.green.editor.model.commands.AddMethodCommand;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;

public class AddMethodAction
extends ContextAction {
    public void doRun() throws JavaModelException {
        String typeString = null;
        TypeModel typeModel = this._model.getTypeModel();
        NewMethodWizard wizard = new NewMethodWizard(typeModel);
        WizardDialog dialog = new WizardDialog(this.getEditor().getSite().getShell(), (IWizard)wizard);
        dialog.setMinimumPageSize(300, 500);
        dialog.create();
        int res = dialog.open();
        if (res == 0) {
            boolean abstr;
            String methodName = wizard.getMethodName();
            String modifiers = wizard.getModifiers();
            String returnTypeName = wizard.getReturnTypeName();
            String body = this.getBody(returnTypeName);
            boolean bl = abstr = modifiers.indexOf("abstract") != -1;
            if (typeModel.isClass() && !abstr) {
                typeString = " {\n\t" + body + "\n}";
            } else if (typeModel.isInterface() || abstr) {
                typeString = ";";
            } else {
                GreenException.illegalOperation("Invalid type");
            }
            String methodString = String.valueOf(modifiers) + " " + returnTypeName + " " + methodName + "()" + typeString + '\n';
            DiagramEditor editor = (DiagramEditor)this._selectionProvider;
            editor.execute(new AddMethodCommand(methodName, methodString, typeModel));
        }
        this.getEditor().autoSave();
    }

    public String getLabel() {
        return "Add Method";
    }

    protected int getSupportedModels() {
        return 5;
    }

    public String getBody(String typeName) {
        if (typeName.equals("void")) {
            return "";
        }
        if (typeName.equals("byte") || typeName.equals("char") || typeName.equals("short") || typeName.equals("long") || typeName.equals("int") || typeName.equals("float") || typeName.equals("double") || typeName.equals("boolean")) {
            return "return 0;";
        }
        return "return null;";
    }

    public Submenu getPath() {
        return Submenu.Add;
    }

    public boolean isEnabled() {
        return !this.isBinary();
    }
}

