/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.cse.green.editor.model;

import edu.buffalo.cse.green.GreenException;
import edu.buffalo.cse.green.PlugIn;
import edu.buffalo.cse.green.editor.DiagramEditor;
import edu.buffalo.cse.green.editor.controller.AbstractPart;
import edu.buffalo.cse.green.editor.controller.PropertyChange;
import edu.buffalo.cse.green.editor.model.AbstractModel;
import edu.buffalo.cse.green.editor.model.RelationshipKind;
import edu.buffalo.cse.green.editor.model.RootModel;
import edu.buffalo.cse.green.editor.model.TypeModel;
import edu.buffalo.cse.green.editor.model.commands.DeleteCommand;
import edu.buffalo.cse.green.editor.model.commands.HideRelationshipCommand;
import edu.buffalo.cse.green.editor.view.GreenBendpoint;
import edu.buffalo.cse.green.relationships.Relationship;
import edu.buffalo.cse.green.relationships.RelationshipGroup;
import edu.buffalo.cse.green.relationships.RelationshipRemover;
import edu.buffalo.cse.green.xml.XMLConverter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.MethodDeclaration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationshipModel
extends AbstractModel<AbstractModel, RootModel, IJavaElement>
implements Cloneable {
    private IType _sourceType;
    private IType _targetType;
    private List<GreenBendpoint> _bendpoints = new ArrayList<GreenBendpoint>();
    private Class _partClass = null;
    private Set<Relationship> _relationships = new HashSet<Relationship>();
    private String REL_NOT_SUPPORTED = "The desired relationship is not supported";

    public String getCardinality() throws JavaModelException {
        MethodDeclaration dec;
        boolean isGeneric = false;
        int min = 999999;
        int max = 0;
        int constructors = 0;
        int uConstructors = 0;
        HashMap<ASTNode, Integer> cardinality = new HashMap<ASTNode, Integer>();
        RelationshipKind flags = PlugIn.getRelationshipGroup(this.getPartClass()).getFlags();
        if (flags.equals((Object)RelationshipKind.Single)) {
            return "1";
        }
        if (flags.equals((Object)RelationshipKind.Cumulative)) {
            for (Relationship relationship : this._relationships) {
                ASTNode locator = relationship.getFeatures().get(0);
                while (!(locator instanceof MethodDeclaration)) {
                    locator = locator.getParent();
                }
                dec = (MethodDeclaration)locator;
                if (dec.isConstructor()) continue;
                isGeneric = true;
            }
        }
        dec = this._sourceType.getMethods();
        int n = 0;
        int locator = ((IMethod[])dec).length;
        while (n < locator) {
            IMethod method = dec[n];
            if (method.isConstructor()) {
                ++constructors;
            }
            ++n;
        }
        for (Relationship relationship : this._relationships) {
            int card;
            ASTNode locator2 = relationship.getFeatures().get(0);
            while (locator2.getNodeType() != 31) {
                locator2 = locator2.getParent();
            }
            if (cardinality.get(locator2) == null) {
                card = 0;
                ++uConstructors;
            } else {
                card = (Integer)cardinality.get(locator2);
            }
            MethodDeclaration dec2 = (MethodDeclaration)locator2;
            if (!dec2.isConstructor()) continue;
            if (relationship.isGeneric()) {
                isGeneric = true;
                cardinality.put(locator2, card + relationship.getFeatures().size() - 2);
                continue;
            }
            cardinality.put(locator2, card + 1);
        }
        for (Integer card : cardinality.values()) {
            if (card < min) {
                min = card;
            }
            if (card <= max) continue;
            max = card;
        }
        if (uConstructors < constructors) {
            min = 0;
        }
        if (min == 999999) {
            min = 0;
        }
        if (isGeneric) {
            return String.valueOf(min) + "..*";
        }
        if (min == max) {
            return "" + min;
        }
        return String.valueOf(min) + ".." + max;
    }

    public RelationshipModel() {
    }

    public RelationshipModel(IType sourceType, IType targetType, Class partClass) {
        this();
        this._partClass = partClass;
        this._sourceType = sourceType;
        this._targetType = targetType;
    }

    public boolean addRelationship(Relationship relationship) {
        return this._relationships.add(relationship);
    }

    public IType getSourceType() {
        return this._sourceType;
    }

    public IType getTargetType() {
        return this._targetType;
    }

    @Override
    public Class getPartClass() {
        if (this._partClass == null) {
            GreenException.illegalOperation("Part class is null");
        }
        return this._partClass;
    }

    public void setPartClass(Class partClass) {
        this._partClass = partClass;
    }

    public TypeModel getSourceModel() {
        if (this.getSourceType() == null) {
            return null;
        }
        return this.getRootModel().getModelFromType(this._sourceType);
    }

    public TypeModel getTargetModel() {
        if (this.getTargetType() == null) {
            return null;
        }
        return this.getRootModel().getModelFromType(this._targetType);
    }

    public void setSourceModel(TypeModel newSource) {
        this._sourceType = newSource.getType();
        this.firePropertyChange(PropertyChange.RelationshipSource, null, newSource);
    }

    public void setTargetModel(TypeModel newTarget) {
        this._targetType = newTarget.getType();
        this.firePropertyChange(PropertyChange.RelationshipTarget, null, newTarget);
    }

    public void setBendpointList(List<GreenBendpoint> list) {
        this._bendpoints = list;
    }

    public List<GreenBendpoint> getBendpointList() {
        return this._bendpoints;
    }

    public String getRelationshipName() {
        return PlugIn.getRelationshipName(this.getPartClass());
    }

    public RelationshipGroup getRelationshipGroup() {
        return PlugIn.getRelationshipGroup(this.getPartClass());
    }

    @Override
    public void setVisible(boolean isVisible) {
        boolean modelVisible = isVisible;
        if (!this.getRelationshipGroup().isVisible()) {
            isVisible = false;
        }
        TypeModel sModel = this.getSourceModel();
        TypeModel tModel = this.getTargetModel();
        if (isVisible) {
            if (sModel == null || tModel == null) {
                return;
            }
            if (!sModel.isVisible() || !tModel.isVisible()) {
                return;
            }
            if (sModel.getImplicitRelationships().contains(this)) {
                sModel.removeImplicitRelationship(this);
            }
            if (tModel.getImplicitRelationships().contains(this)) {
                tModel.removeImplicitRelationship(this);
            }
        }
        super.setVisible(modelVisible);
    }

    @Override
    public void toXML(XMLConverter converter) {
        converter.pushHeader("relationship");
        converter.writeKey("class", this.getPartClass().getName());
        converter.writeKey("sourceType", this._sourceType.getHandleIdentifier());
        converter.writeKey("targetType", this._targetType.getHandleIdentifier());
        converter.pushHeader("bendpoints");
        for (GreenBendpoint bendpoint : this.getBendpointList()) {
            converter.pushHeader("bendpoint");
            converter.writeKey("x", bendpoint.getAbsoluteLocation().x);
            converter.writeKey("y", bendpoint.getAbsoluteLocation().y);
            converter.popHeader();
        }
        converter.popHeader();
        super.toXML(converter);
        converter.popHeader();
    }

    public void showRelationshipExplicitly(boolean show) {
        if (this.isVisible() == show || !this.getRelationshipGroup().isVisible()) {
            return;
        }
        if (show) {
            this.getSourceModel().removeImplicitRelationship(this);
            this.getTargetModel().removeImplicitRelationship(this);
            if (this.getSourceModel().isVisible() && this.getTargetModel().isVisible()) {
                this.setVisible(true);
            }
        } else if (!show) {
            this.getSourceModel().addImplicitRelationship(this);
            this.getTargetModel().addImplicitRelationship(this);
            this.setVisible(false);
        }
    }

    @Override
    public int getContextMenuFlag() {
        return 16;
    }

    @Override
    public DeleteCommand getDeleteCommand(DiagramEditor editor) {
        return new DeleteRelationshipCommand(editor, this);
    }

    public Command getHideCommand(DiagramEditor editor) {
        return new HideRelationshipCommand(this);
    }

    @Override
    public IJavaElement getJavaElement() {
        return null;
    }

    public Set<Relationship> getRelationships() {
        return this._relationships;
    }

    public Relationship contains(Relationship relationship) {
        for (Relationship rel : this._relationships) {
            if (!rel.equals(relationship)) continue;
            return rel;
        }
        return null;
    }

    @Override
    public void removeFromParent() {
        RootModel root = this.getRootModel();
        if (root.getChildren().contains(this)) {
            if (this.getSourceModel() != null) {
                this.getSourceModel().removeOutgoingEdge(this);
            }
            if (this.getTargetModel() != null) {
                this.getTargetModel().removeIncomingEdge(this);
            }
            root.removeChildModel(this);
        }
    }

    public void updateCardinality() {
        String cardinality;
        try {
            cardinality = this.getCardinality();
        }
        catch (JavaModelException javaModelException) {
            cardinality = "?";
        }
        this.firePropertyChange(PropertyChange.RelationshipCardinality, null, cardinality);
    }

    @Override
    protected void refresh() {
        this.updateCardinality();
        this.setVisible(this.isVisible());
    }

    public void setBounds(Rectangle bounds) {
        this.setLocation(bounds.getLocation());
        this.setSize(bounds.getSize());
    }

    @Override
    public void assertValid() {
        RelationshipGroup group = PlugIn.getRelationshipGroup(this.getPartClass());
        try {
            if (this.getSourceType().isClass() ? (this.getTargetType().isClass() ? group.isValidClassToClass() : (this.getTargetType().isEnum() ? group.isValidClassToEnum() : this.getTargetType().isInterface() && group.isValidClassToInterface())) : (this.getSourceType().isEnum() ? (this.getTargetType().isClass() ? group.isValidEnumToClass() : (this.getTargetType().isEnum() ? group.isValidEnumToEnum() : this.getTargetType().isInterface() && group.isValidEnumToInterface())) : this.getSourceType().isInterface() && (this.getTargetType().isClass() ? group.isValidInterfaceToClass() : (this.getTargetType().isEnum() ? group.isValidInterfaceToEnum() : this.getTargetType().isInterface() && group.isValidInterfaceToInterface())))) {
                return;
            }
            GreenException.illegalOperation(this.REL_NOT_SUPPORTED);
        }
        catch (JavaModelException e) {
            GreenException.illegalOperation(e.getLocalizedMessage());
        }
    }

    @Override
    public String toString() {
        return this.getSourceModel() + "," + this.getTargetModel() + "," + this.getPartClass();
    }

    @Override
    public void handleDispose() {
    }

    @Override
    public void createNewInstance(AbstractModel model) {
        this.getRootModel().addChild((RelationshipModel)model);
    }

    class DeleteRelationshipCommand
    extends DeleteCommand {
        private RelationshipModel _rModel;
        private DiagramEditor _editor;

        public DeleteRelationshipCommand(DiagramEditor editor, RelationshipModel relationship) {
            this._editor = editor;
            this._rModel = relationship;
        }

        public void doDelete() {
            AbstractPart part = this._editor.getRootPart().getPartFromModel(this._rModel);
            RelationshipGroup group = PlugIn.getRelationshipGroup(((Object)((Object)part)).getClass());
            RelationshipRemover remover = group.getRemover();
            remover.setRelationship(this._rModel);
            remover.run(remover.getCompilationUnit(this._rModel.getSourceType()), null);
            remover.setRelationship(null);
            RelationshipModel.this.getSourceModel().updateFields();
            RelationshipModel.this.getSourceModel().updateMethods();
        }

        public String getDeleteMessage() {
            if (RelationshipModel.this.getSourceType().isBinary()) {
                return null;
            }
            return "Are you sure you want to delete that relationship?";
        }
    }
}

