/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.cse.green.xml;

import edu.buffalo.cse.green.xml.XMLNode;
import java.util.Map;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLConverter {
    private StringBuffer _buf = new StringBuffer();
    private Stack<XMLNode> _headers = new Stack();

    public XMLNode getDecodedXML(String xml) throws ArrayIndexOutOfBoundsException {
        int pos;
        XMLNode node;
        XMLNode currentNode = node = new XMLNode("!root");
        while ((pos = xml.indexOf(10)) != -1) {
            String line = xml.substring(0, pos);
            xml = xml.substring(pos + 1);
            if (line.length() < 3) continue;
            currentNode = this.addLineToNode(currentNode, line);
        }
        return node;
    }

    public String getEncodedXML() {
        this._headers.clear();
        return this._buf.toString();
    }

    public void pushHeader(XMLNode header) {
        this.appendToBuffer("<" + header + ">");
        this._headers.push(header);
    }

    public void pushHeader(String header) {
        this.pushHeader(new XMLNode(header));
    }

    public void openHeader(String header, String value) {
        this.appendToBuffer("<" + header + "=\"" + value + "\">");
        this._headers.push(new XMLNode(header));
    }

    public void popHeader() {
        this.appendToBuffer("</" + this._headers.pop() + ">");
    }

    public void writeKey(String header, Object value) {
        this.appendToBuffer("<" + header + "=\"" + value + "\"/>");
    }

    public void writeMap(Map<String, String> map) {
        for (String key : map.keySet()) {
            this.writeKey(key, map.get(key).toString());
        }
    }

    private void appendToBuffer(String appendString) {
        int x = 0;
        while (x < this._headers.size()) {
            this._buf.append("   ");
            ++x;
        }
        this._buf.append(String.valueOf(appendString) + "\n");
    }

    private XMLNode addLineToNode(XMLNode node, String line) {
        if ((line = line.substring(line.indexOf("<")).trim()).substring(0, 2).equals("</")) {
            return this._headers.pop();
        }
        int len = line.length();
        if (line.substring(len - 2, len).equals("/>")) {
            int pos = line.indexOf("=");
            String key = line.substring(1, pos);
            String val = line.substring(pos + 2, len - 3);
            node.getAttributes().put(key, val);
            return node;
        }
        this.pushHeader(node);
        String name = line.substring(1, len - 1);
        XMLNode newNode = new XMLNode(name);
        node.addChild(newNode);
        return newNode;
    }
}

