/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.cse.green.editor.controller;

import edu.buffalo.cse.green.PlugIn;
import edu.buffalo.cse.green.editor.controller.AbstractPart;
import edu.buffalo.cse.green.editor.controller.JavadocGrabber;
import edu.buffalo.cse.green.editor.controller.MemberPart;
import edu.buffalo.cse.green.editor.controller.PropertyChange;
import edu.buffalo.cse.green.editor.controller.policies.GreenSelectionEditPolicy;
import edu.buffalo.cse.green.editor.controller.policies.RelationshipSourceAndTargetCreationEditPolicy;
import edu.buffalo.cse.green.editor.model.TypeModel;
import edu.buffalo.cse.green.editor.model.commands.DeleteCommand;
import edu.buffalo.cse.green.editor.model.commands.DeleteTypeCommand;
import edu.buffalo.cse.green.editor.view.IIconHolder;
import edu.buffalo.cse.green.editor.view.ITypeFigure;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class TypePart
extends MemberPart
implements NodeEditPart {
    protected IFigure doCreateFigure() {
        ITypeFigure f = (ITypeFigure)this.generateFigure();
        f.setLocation(this.model().getLocation());
        f.setSize(this.model().getSize());
        f.getNameLabel().setFont(PlugIn.getFontPreference("font", false, false));
        return f;
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        GraphicalEditPart parent = (GraphicalEditPart)this.getParent();
        parent.setLayoutConstraint((EditPart)this, (IFigure)this.figure(), (Object)new Rectangle(this.model().getLocation(), this.model().getSize()));
        this.figure().validate();
    }

    public void updateIcon() {
        if (Display.getCurrent() != null) {
            this.getNameLabel().setIcon(this.model().getIcon());
        } else {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    TypePart.this.getNameLabel().setIcon(TypePart.this.model().getIcon());
                }
            });
        }
    }

    public void updateLabel() {
        this.repaintLabel(this.getNameLabel());
    }

    public void updateFont() {
        if (Display.getCurrent() != null) {
            this.updateFontHelper();
        } else {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    TypePart.this.updateFontHelper();
                }
            });
        }
    }

    private void updateFontHelper() {
        try {
            Font font = this.getNameLabel().getFont();
            font.dispose();
            boolean italic = this.model().isAbstract() || this.model().isInterface();
            this.getNameLabel().setFont(PlugIn.getFontPreference("font", false, italic));
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
    }

    public DeleteCommand getDeleteCommand() {
        return new DeleteTypeCommand(this.model());
    }

    protected void addPropertyListeners() {
        super.addPropertyListeners();
        this.addListener(PropertyChange.IncomingRelationship, new AbstractPart.ChildAndVisualsUpdater());
        this.addListener(PropertyChange.OutgoingRelationship, new AbstractPart.ChildAndVisualsUpdater());
    }

    protected void onDoubleClick() {
        this.getOpenElementAction().run();
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new RelationshipSourceAndTargetCreationEditPolicy());
        this.installEditPolicy("Selection Feedback", (EditPolicy)new GreenSelectionEditPolicy());
    }

    protected boolean hasFieldCompartment() {
        try {
            return this.model().getType().isClass();
        }
        catch (JavaModelException e) {
            e.printStackTrace();
            return false;
        }
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        return new ChopboxAnchor((IFigure)this.figure());
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        return new ChopboxAnchor((IFigure)this.figure());
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        return new ChopboxAnchor((IFigure)this.figure());
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return new ChopboxAnchor((IFigure)this.figure());
    }

    public IIconHolder getNameLabel() {
        return this.figure().getNameLabel();
    }

    private TypeModel model() {
        return (TypeModel)this.getModel();
    }

    public void deactivate() {
        Image image = this.getNameLabel().getIcon();
        Font font = this.getNameLabel().getFont();
        if (image != null) {
            image.dispose();
        }
        if (font != null && this.figure().shouldDisposeFont()) {
            font.dispose();
        }
        super.deactivate(false);
    }

    private ITypeFigure figure() {
        return (ITypeFigure)this.getFigure();
    }

    protected void updateColors(IFigure f) {
        ITypeFigure tf = (ITypeFigure)f;
        f.setBorder((Border)new LineBorder(PlugIn.getColorPreference("color.type.border"), 2));
        f.setBackgroundColor(PlugIn.getColorPreference("color.uml"));
        tf.getNameLabel().setForegroundColor(PlugIn.getColorPreference("color.type.text"));
        if (this.model().getImplicitRelationships().size() == 0) {
            f.setBorder((Border)new LineBorder(PlugIn.getColorPreference("color.type.border"), 2));
        } else {
            f.setBorder((Border)new LineBorder(PlugIn.getColorPreference("color.type.border.hiddenr"), 2));
        }
    }

    public void setInitialBackgroundColor() {
        this.getNameLabel().getParent().setBackgroundColor(PlugIn.getColorPreference("color.uml"));
        this.getNameLabel().setOpaque(false);
    }

    public void setSelectedBackgroundColor() {
        this.getNameLabel().getParent().setBackgroundColor(PlugIn.getColorPreference("color.selected"));
        this.getNameLabel().setOpaque(false);
    }

    protected JavadocGrabber getJavadocGrabber() {
        return new JavadocGrabber(){
            private boolean _alive = true;

            public boolean visit(EnumDeclaration node) {
                return this.visitNode((AbstractTypeDeclaration)node);
            }

            public boolean visit(TypeDeclaration node) {
                return this.visitNode((AbstractTypeDeclaration)node);
            }

            private boolean visitNode(AbstractTypeDeclaration node) {
                if (!this._alive) {
                    return false;
                }
                IType type = (IType)node.resolveBinding().getJavaElement();
                if (this.checkDoc(type)) {
                    this._doc = TypePart.this.getDoc(node.getJavadoc());
                }
                return this._alive;
            }

            private boolean checkDoc(IType type) {
                if (this.compareElements((IJavaElement)type)) {
                    this._alive = false;
                    return true;
                }
                return false;
            }
        };
    }

    public IFigure getRelLabel() {
        return this.figure().getRelLabel();
    }
}

