/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.cse.green.editor.model;

import edu.buffalo.cse.green.GreenException;
import edu.buffalo.cse.green.editor.DiagramEditor;
import edu.buffalo.cse.green.editor.controller.PropertyChange;
import edu.buffalo.cse.green.editor.controller.PropertyListener;
import edu.buffalo.cse.green.editor.model.CombinedListener;
import edu.buffalo.cse.green.editor.model.RootModel;
import edu.buffalo.cse.green.editor.model.TypeModel;
import edu.buffalo.cse.green.editor.model.commands.DeleteCommand;
import edu.buffalo.cse.green.xml.XMLConverter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.jdt.core.IJavaElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractModel<C extends AbstractModel, P extends AbstractModel, E extends IJavaElement> {
    private Map<PropertyChange, PropertyListener> _listeners;
    private List<C> _children;
    private boolean _isVisible = true;
    private Point _location = new Point(1, 1);
    private P _parent;
    private Dimension _size = new Dimension(1, 1);
    private Dimension _drawnSize;

    protected AbstractModel() {
        this._children = new ArrayList<C>();
        this._listeners = new HashMap<PropertyChange, PropertyListener>();
    }

    public abstract Class getPartClass();

    public void setProperty(String property, Object value) {
        this.getRootModel().setProperty(property, value);
    }

    public Object getProperty(String property) {
        return this.getRootModel().getProperty(property);
    }

    public void toggleProperty(String property) {
        this.getRootModel().toggleProperty(property);
    }

    public RootModel getRootModel() {
        return ((AbstractModel)this._parent).getRootModel();
    }

    public void setLocation(Point iLocation) {
        this._location = iLocation;
        this.firePropertyChange(PropertyChange.Location, null, iLocation);
    }

    public void setLocation(int x, int y) {
        this.setLocation(new Point(x, y));
    }

    public Point getLocation() {
        return this._location;
    }

    public void setSize(Dimension iSize) {
        if (iSize == null) {
            return;
        }
        Dimension oldSize = this._size;
        this._size = iSize;
        this.firePropertyChange(PropertyChange.Size, oldSize, iSize);
    }

    public void setSize(int width, int height) {
        this.setSize(new Dimension(width, height));
    }

    public Dimension getSize() {
        return this._size;
    }

    protected final void addChild(C model, IJavaElement element) {
        if (!this.equals(((AbstractModel)model).getParent())) {
            if (((AbstractModel)model).getParent() != null) {
                GreenException.illegalOperation("Model already has a parent");
            }
            ((AbstractModel)model).setParent((AbstractModel)this);
        }
        if (element != null) {
            this.getRootModel().mapElementToModel(element, (AbstractModel)model);
        }
        this._children.add(model);
        this.firePropertyChange(PropertyChange.Children, null, model);
    }

    protected final boolean removeChild(AbstractModel model) {
        boolean removed = this._children.remove(model);
        this.firePropertyChange(PropertyChange.Children, model, null);
        this.dispose();
        if (this.getJavaElement() != null) {
            this.getRootModel().unmapElement((IJavaElement)this.getJavaElement());
        }
        return removed;
    }

    public List<C> getChildren() {
        return this._children;
    }

    public void addListener(PropertyChange type, PropertyListener listener) {
        boolean exists = this._listeners.containsKey((Object)type);
        if (exists) {
            this._listeners.put(type, new CombinedListener(this._listeners.get((Object)type), listener));
        } else {
            this._listeners.put(type, listener);
        }
    }

    public void firePropertyChange(PropertyChange type, Object oValue, Object nValue) {
        PropertyListener listener = this._listeners.get((Object)type);
        if (listener != null) {
            listener.notify(oValue, nValue);
        }
    }

    protected final void firePropertyChange(PropertyChange type) {
        this.firePropertyChange(type, false, true);
    }

    public P getParent() {
        return this._parent;
    }

    public void setParent(P parent) {
        this._parent = parent;
    }

    public void toXML(XMLConverter converter) {
        for (AbstractModel model : this.getChildren()) {
            model.toXML(converter);
        }
    }

    public void setVisible(boolean show) {
        this._isVisible = show;
        if (show) {
            this.firePropertyChange(PropertyChange.Visibility, null, true);
        } else {
            this.firePropertyChange(PropertyChange.Visibility, null, false);
        }
    }

    public boolean isVisible() {
        return this._isVisible;
    }

    public int getContextMenuFlag() {
        return 32;
    }

    public List<C> getChildren(Class klass) {
        ArrayList<AbstractModel> children = new ArrayList<AbstractModel>();
        for (AbstractModel model : this._children) {
            if (!klass.isInstance(model)) continue;
            children.add(model);
        }
        return children;
    }

    protected void refresh() {
        for (AbstractModel model : this.getChildren()) {
            model.refresh();
        }
        this.firePropertyChange(PropertyChange.Refresh);
    }

    public void forceRefesh() {
        this.firePropertyChange(PropertyChange.Refresh);
    }

    public abstract DeleteCommand getDeleteCommand(DiagramEditor var1);

    public Rectangle getBounds() {
        return new Rectangle(this.getLocation(), this.getSize());
    }

    public abstract E getJavaElement();

    public abstract void removeFromParent();

    public abstract String toString();

    public final void removeChildren() {
        ArrayList<C> children = new ArrayList<C>();
        children.addAll(this.getChildren());
        for (AbstractModel model : children) {
            model.removeFromParent();
        }
        this.firePropertyChange(PropertyChange.Children);
    }

    public final void dispose() {
        this.handleDispose();
        for (AbstractModel model : this.getChildren()) {
            model.dispose();
        }
    }

    public abstract void handleDispose();

    public TypeModel getTypeModel() {
        GreenException.illegalOperation("Invalid operation");
        return null;
    }

    public int invokeCreationDialog(ToolEntry tool) {
        GreenException.illegalOperation("This operation is not supported");
        return 0;
    }

    public void createNewInstance(AbstractModel model) {
        GreenException.illegalOperation("This operation is not supported");
    }

    public void assertValid() {
    }

    public Dimension getDrawnSize() {
        return this._drawnSize;
    }

    public void setDrawnSize(Dimension size) {
        this._drawnSize = size;
    }
}

