/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.cse.green.editor.model;

import edu.buffalo.cse.green.GreenException;
import edu.buffalo.cse.green.PlugIn;
import edu.buffalo.cse.green.dialogs.NewElementWizard;
import edu.buffalo.cse.green.editor.DiagramEditor;
import edu.buffalo.cse.green.editor.controller.PropertyChange;
import edu.buffalo.cse.green.editor.controller.TypePart;
import edu.buffalo.cse.green.editor.model.AbstractModel;
import edu.buffalo.cse.green.editor.model.CompartmentModel;
import edu.buffalo.cse.green.editor.model.FieldModel;
import edu.buffalo.cse.green.editor.model.MemberModel;
import edu.buffalo.cse.green.editor.model.MethodModel;
import edu.buffalo.cse.green.editor.model.RelationshipModel;
import edu.buffalo.cse.green.editor.model.RootModel;
import edu.buffalo.cse.green.editor.model.commands.DeleteCommand;
import edu.buffalo.cse.green.editor.model.commands.DeleteTypeCommand;
import edu.buffalo.cse.green.editor.model.commands.HideTypeCommand;
import edu.buffalo.cse.green.types.ITypeProperties;
import edu.buffalo.cse.green.xml.XMLConverter;
import java.lang.reflect.Constructor;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.refactoring.RenameSupport;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchWindow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeModel
extends MemberModel<CompartmentModel, RootModel, IType> {
    private HashSet<RelationshipModel> _incomingEdges = new HashSet();
    private HashSet<RelationshipModel> _outgoingEdges = new HashSet();
    private HashSet<RelationshipModel> _implicitRelationships = new HashSet();
    private CompartmentModel _nameCompartment = CompartmentModel.newTypeCompartment();
    private CompartmentModel _fieldCompartment;
    private CompartmentModel _methodCompartment;

    public TypeModel() {
        this(null);
    }

    protected TypeModel(IType type) {
        super(type);
        this.setLocation(new Point(50, 50));
        this.setSize(new Dimension(-1, -1));
        this.addChild(this._nameCompartment);
        if (type != null) {
            ITypeProperties properties = TypeModel.getTypeProperties(type);
            if (properties.hasFieldCompartment()) {
                this._fieldCompartment = CompartmentModel.newFieldCompartment();
                this.addChild(this._fieldCompartment);
            }
            if (properties.hasMethodCompartment()) {
                this._methodCompartment = CompartmentModel.newMethodCompartment();
                this.addChild(this._methodCompartment);
            }
        }
    }

    private void addChild(CompartmentModel compartment) {
        this.addChild(compartment, null);
    }

    public void addChild(FieldModel model) {
        CompartmentModel cm = this.getFieldCompartmentModel();
        if (cm == null) {
            return;
        }
        if (!PlugIn.filterMember(model)) {
            cm.addChild(model);
        } else {
            cm.removeChild(model);
        }
    }

    public void addChild(MethodModel model) {
        if (!PlugIn.filterMember(model)) {
            this.getMethodCompartmentModel().addChild(model);
        } else {
            this.getMethodCompartmentModel().removeChild(model);
        }
    }

    @Override
    public String getDisplayName() {
        boolean fqn = PlugIn.getBooleanPreference("display.fqn.type.names");
        return fqn ? this.getType().getFullyQualifiedName() : this.getType().getElementName();
    }

    public void updateMethods() {
        CompartmentModel compartment = this.getMethodCompartmentModel();
        compartment.removeChildren();
        try {
            IMethod[] methods = this.getType().getMethods();
            int j = 0;
            while (j < methods.length) {
                MethodModel mModel = new MethodModel(methods[j]);
                this.addChild(mModel);
                ++j;
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
    }

    public void updateFields() {
        CompartmentModel compartment = this.getFieldCompartmentModel();
        if (compartment == null) {
            return;
        }
        compartment.removeChildren();
        try {
            IField[] fields = this.getType().getFields();
            int j = 0;
            while (j < fields.length) {
                FieldModel fModel = new FieldModel(fields[j]);
                this.addChild(fModel);
                ++j;
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
    }

    public Set<RelationshipModel> getIncomingEdges() {
        return this._incomingEdges;
    }

    public Set<RelationshipModel> getOutgoingEdges() {
        return this._outgoingEdges;
    }

    public void addIncomingEdge(RelationshipModel relationshipModel) {
        this._incomingEdges.add(relationshipModel);
        this.firePropertyChange(PropertyChange.IncomingRelationship, null, relationshipModel);
    }

    public void removeIncomingEdge(RelationshipModel relationshipModel) {
        if (this._incomingEdges.contains(relationshipModel)) {
            this._incomingEdges.remove(relationshipModel);
            this.firePropertyChange(PropertyChange.IncomingRelationship, relationshipModel, null);
        }
    }

    public void addOutgoingEdge(RelationshipModel edge) {
        this._outgoingEdges.add(edge);
        this.firePropertyChange(PropertyChange.OutgoingRelationship, null, edge);
    }

    public void removeOutgoingEdge(RelationshipModel edge) {
        if (this._outgoingEdges.remove(edge)) {
            this.firePropertyChange(PropertyChange.OutgoingRelationship, edge, null);
        }
    }

    @Override
    public void toXML(XMLConverter converter) {
        converter.pushHeader("type");
        converter.writeKey("name", this.getType().getHandleIdentifier());
        converter.writeKey("height", "" + this.getSize().height);
        converter.writeKey("width", "" + this.getSize().width);
        converter.writeKey("x", "" + this.getLocation().x);
        converter.writeKey("y", "" + this.getLocation().y);
        super.toXML(converter);
        converter.popHeader();
    }

    public Set<RelationshipModel> getImplicitRelationships() {
        return this._implicitRelationships;
    }

    public void addImplicitRelationship(RelationshipModel rModel) {
        this._implicitRelationships.add(rModel);
        this.firePropertyChange(PropertyChange.Refresh);
    }

    public void removeImplicitRelationship(RelationshipModel rModel) {
        this._implicitRelationships.remove(rModel);
        this.setVisible(true);
        if (this._implicitRelationships.size() == 0) {
            this.firePropertyChange(PropertyChange.Refresh);
        }
    }

    public IType getType() {
        return (IType)this.getMember();
    }

    public CompartmentModel getNameCompartmentModel() {
        return this._nameCompartment;
    }

    public CompartmentModel getFieldCompartmentModel() {
        return this._fieldCompartment;
    }

    public CompartmentModel getMethodCompartmentModel() {
        return this._methodCompartment;
    }

    public boolean isClass() {
        if (!((IType)this.getMember()).exists()) {
            return false;
        }
        try {
            return this.getType().isClass();
        }
        catch (JavaModelException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean isInterface() throws JavaModelException {
        if (!((IType)this.getMember()).exists()) {
            return false;
        }
        return this.getType().isInterface();
    }

    public boolean isAbstract() throws JavaModelException {
        if (!((IType)this.getMember()).exists()) {
            return false;
        }
        return Flags.isAbstract((int)this.getType().getFlags());
    }

    @Override
    public int getContextMenuFlag() {
        return 1;
    }

    @Override
    public void removeFromParent() {
        this.removeChildren();
        this.getRootModel().removeChildModel(this);
        super.removeFromParent();
    }

    @Override
    public DeleteCommand getDeleteCommand(DiagramEditor editor) {
        return new DeleteTypeCommand(this);
    }

    public Command getHideCommand(DiagramEditor editor) {
        return new HideTypeCommand(this);
    }

    @Override
    public Class getPartClass() {
        return TypePart.class;
    }

    @Override
    public void setVisible(boolean value) {
        super.setVisible(value);
        if (value) {
            for (RelationshipModel rModel : this.getIncomingEdges()) {
                rModel.setVisible(true);
            }
            for (RelationshipModel rModel : this.getOutgoingEdges()) {
                rModel.setVisible(true);
            }
        }
    }

    @Override
    public TypeModel getTypeModel() {
        return this;
    }

    @Override
    public RenameSupport getRenameSupport() throws CoreException {
        return RenameSupport.create((IType)this.getType(), (String)"", (int)1);
    }

    @Override
    public int invokeCreationDialog(ToolEntry tool) {
        ITypeProperties properties = TypeModel.getTypeProperties(tool.getLabel());
        Class klass = properties.getDialogClass();
        Constructor<?> constructor = klass.getConstructors()[0];
        if (constructor.getParameterTypes().length != 0) {
            GreenException.illegalOperation("Constructor must not have any parameters");
        }
        try {
            NewElementWizard wizard = (NewElementWizard)((Object)constructor.newInstance(new Object[0]));
            wizard.setModel(this);
            wizard.init(PlugIn.getDefault().getWorkbench(), this.getCurrentSelection());
            WizardDialog dialog = new WizardDialog(PlugIn.getDefaultShell(), (IWizard)wizard);
            dialog.setMinimumPageSize(300, 500);
            dialog.create();
            dialog.open();
            return dialog.getReturnCode();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
    }

    @Override
    public void createNewInstance(AbstractModel model) {
        RootModel root = model.getRootModel();
        TypeModel typeModel = (TypeModel)model;
        typeModel = root.createTypeModel(typeModel.getType());
        typeModel.setLocation(model.getLocation());
        typeModel.setSize(model.getSize());
        root.updateRelationships();
    }

    private IStructuredSelection getCurrentSelection() {
        IWorkbenchWindow[] windows = PlugIn.getDefault().getWorkbench().getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            ISelection selection;
            IViewPart packExplorer = windows[i].getPages()[0].findView("org.eclipse.jdt.ui.PackageExplorer");
            if (packExplorer != null && (selection = packExplorer.getViewSite().getSelectionProvider().getSelection()) instanceof IStructuredSelection) {
                return (IStructuredSelection)selection;
            }
            ++i;
        }
        return null;
    }

    @Override
    public void assertValid() {
        GreenException.illegalOperation(this.getRootModel().isValidTypeModel(this));
    }

    @Override
    public void refresh() {
        if (((IType)this.getMember()).exists()) {
            this.updateFields();
            this.updateMethods();
        }
        super.refresh();
    }

    private static ITypeProperties getTypeProperties(IType type) {
        return TypeModel.getTypeProperties(TypeModel.getTypeAsString(type));
    }

    private static ITypeProperties getTypeProperties(String key) {
        ITypeProperties properties = PlugIn.getTypeProperties().get(key);
        if (properties == null) {
            GreenException.illegalOperation("Type is Unsupported.");
        }
        return properties;
    }

    private static String getTypeAsString(IType type) {
        for (ITypeProperties typeProp : PlugIn.getAvailableTypes()) {
            if (!typeProp.supportsType(type)) continue;
            return typeProp.getLabel();
        }
        GreenException.illegalOperation("Type is Unsupported.");
        return null;
    }
}

