/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.cse.green.util;

import edu.buffalo.cse.green.util.ImageWriterUtil;
import org.eclipse.draw2d.IFigure;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.RGB;

public abstract class ImageWriter {
    protected ImageLoader _imageIO;
    protected int _format;
    protected RGB _backgroundColor;

    public ImageWriter(int imageLoaderFormat) {
        this._format = imageLoaderFormat;
        this._imageIO = new ImageLoader();
        this._imageIO.logicalScreenWidth = 1;
        this._imageIO.logicalScreenWidth = 1;
    }

    public void saveFigure(IFigure figure) {
        if (this._backgroundColor == null) {
            ImageWriterUtil.writeFigureToLoader(figure, this._imageIO, this._format);
        } else {
            ImageWriterUtil.writeFigureToLoader(figure, this._imageIO, this._format, this._backgroundColor);
        }
        this.saveImageToStream();
    }

    public void saveImage(Image image) {
        ImageWriterUtil.writeImageToLoader(image, this._imageIO, this._format);
        this.saveImageToStream();
    }

    public void setBackgroundColor(RGB backgroundColor) {
        this._backgroundColor = backgroundColor;
    }

    protected abstract void saveImageToStream();
}

