import greenfoot.*;  // (World, Actor, GreenfootImage, Greenfoot and MouseInfo)

/**
 * The world where the game is played
 * 
 * @author Michael Berry
 * @version 21/03/2008
 */
public class AlienWorld extends World
{

    private Score score;

    /**
     * Constructor for objects of class AlienWorld.
     */
    public AlienWorld()
    {
        super(1000, 500, 1);
        
        Greenfoot.setSpeed(98);
        setBackground("images/background.bmp");
        
        score = new Score();
        addObject(score, 100, 40);
        
        addObject(new Ship(), 500, 450);
        
        Alien master = new Alien();  
        addObject(master, 100, 50);

    }
    
    /**
     * Update the score by x points
     * @param x The number of points to add to the score. Negative values of x take points away.
     */
    public void updateScore(int x)
    {
        score.updateScore(x);
    }
    
    /**
     * Ends the scenario
     */
    public void gameOver()
    {
        Greenfoot.stop();
    }
}
